package sellwin.gui;

import sellwin.utils.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class renders a label within a table
 * cell that needs to display a date and time
 * string.
 */
public class DateTimeRenderer extends JLabel implements TableCellRenderer {

	private Date currentDate;

	/**
	 * construct the date time renderer
	 */
	public DateTimeRenderer() {
		super();
		setBackground(MainWindow.LETTERS);
		setFont(MainWindow.FIELD_FONT);
	}

	/**
	 * get the table cell renderer, this method is 
	 * implemented for the TableCellRenderer interface
	 * @param table description
	 * @param date description
	 * @param isSelected description
	 * @param hasFocus description
	 * @param row description
	 * @param col description
	 * @return description
	 */
	public final Component getTableCellRendererComponent(
		JTable table, Object date,
		boolean isSelected, boolean hasFocus,
		int row, int col) {

		currentDate = (Date)date;

		if (date == null)
			date = new Date();
		setText(Prefs.dateTimeFormat.format((Date)date));
		return this;
	}


	/**
	 * get the date this renderer stores
	 * @return the date
	 */
	public final Date getDate() {
		return currentDate;
	}

	/**
	 * implemented for the TableCellRenderer 
	 * @param value the value we are setting with
	 */
	public final void setValue(Object value) {
		if (value == null)
			currentDate = new Date();
		else {
			currentDate = (Date)value;
		}

		setText(Prefs.dateTimeFormat.format((Date)currentDate));
	}
}
