package sellwin.gui;

import sellwin.utils.*;
import sellwin.domain.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class ties the description editor dialog to
 * the activity table's description column
 */
public class DescEditor extends DefaultCellEditor implements DescEditorDialogListener {

	private DescRenderer renderer = new DescRenderer();
	private String currentDesc = null;
	private JButton editorComponent=null;
	private JTable table=null;

	/**
	 * construct the desc editor 
	 * @param b the button that causes the desc editor dialog to popup
	 * @param table the table that will use this trigger
	 */
	public DescEditor(JButton b, JTable table) {
		super(new JCheckBox());
		this.table = table;

		editorComponent = b;
		setClickCountToStart(1);

		b.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				fireEditingStopped();
			}
		});
	}

	/**
	 * get the desc
	 * @return the current date
	 */
	public final String getDesc() {
		return currentDesc;
	}


	/**
	 * set the desc 
	 * @param d the desc
	 */
	public final void setDesc(String d) {
		currentDesc = d;
		((JButton)editorComponent).setText(currentDesc);
		ActivityTableModel model = (ActivityTableModel)table.getModel();
		Activity act = model.getActivity(table.getSelectedRow());
		table.tableChanged(new TableModelEvent(model));
		fireEditingStopped();
	}

	/**
	 * get the table's cell editor component
	 * @param table description
	 * @return description
	 * @exception class-name description
	 */
	public final Component getTableCellEditorComponent(
		JTable table,
		Object value,
		boolean isSelected,
		int row, int col) {

		if (value == null) value = new String("");
		String desc  = (String)value;
		
		((JButton)editorComponent).setText(desc);
		currentDesc = desc;
		return editorComponent;
	}

	/**
	 * fire the editing stopped message
	 */
	protected final void fireEditingStopped() {
		super.fireEditingStopped();
	}

	/**
	 * get the cell editor value 
	 * @return description
	 */
	public final Object getCellEditorValue() {
		return currentDesc;
	}
}
