package sellwin.gui;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * DescEditorDialog.java
 * @author  jmccormi
 *
 * Created on June 9, 2002
 */
public class DescEditorDialog extends JDialog implements GUIChars {

    private JPanel buttonPanel;
    private JButton okButton;
    private JPanel mainPanel;
    private JScrollPane jScrollPane1;
    private JTextArea descTextArea;

	private final DescEditorDialogListener myEditor;

    /** Creates new form DescEditorDialog */
    public DescEditorDialog(Frame parent, DescEditorDialogListener editor) {
        super(parent, "Description", true);
		myEditor = editor;
        initComponents();
		setFonts();
		setColors();
		setLang();

		okButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					myEditor.setDesc(descTextArea.getText());
					hide();
				}
			}
		);

        WindowListener l = new WindowAdapter() {
            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };

		addWindowListener(l);
		getRootPane().setDefaultButton(okButton);
    }

	public final void setDesc(String d) {
		descTextArea.setText(d);
	}

	public final String getDesc() {
		return descTextArea.getText();
	}


	public void setColors() {
	}

	public void setLang() {
	}

	public void setFonts() {
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        buttonPanel = new JPanel();
        okButton = new JButton();
        mainPanel = new JPanel();
        jScrollPane1 = new JScrollPane();
        descTextArea = new JTextArea();
        
        setTitle("Description");
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        okButton.setText("Ok");
        buttonPanel.add(okButton);
        
        getContentPane().add(buttonPanel, BorderLayout.SOUTH);
        
        mainPanel.setBorder(new EtchedBorder());
        descTextArea.setColumns(40);
        descTextArea.setRows(3);
        descTextArea.setPreferredSize(new Dimension(480, 39));
        descTextArea.setMaximumSize(new Dimension(270, 200));
        descTextArea.setMinimumSize(new Dimension(270, 200));
        jScrollPane1.setViewportView(descTextArea);
        
        mainPanel.add(jScrollPane1);
        
        getContentPane().add(mainPanel, BorderLayout.CENTER);
        
        pack();
    }

    /** Closes the dialog */
    private void closeDialog(WindowEvent evt) {
        setVisible(false);
        dispose();
    }
}
