package sellwin.gui;

import javax.swing.*; 
import javax.swing.text.*; 

import java.awt.Toolkit;
import java.text.*;
import java.util.Locale;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class wraps some simple rules to display
 * double numeric data type in a text field
 */
public class DoubleNumberField extends JTextField {
    private Toolkit toolkit;
    private NumberFormat doubleFormatter;

	/**
	 * construct the DoubleNumberField 
	 * @param value the double value to render
	 * @param columns the number of columns to display
	 */
    public DoubleNumberField(double value, int columns) {
        super(columns);
        toolkit = Toolkit.getDefaultToolkit();
        doubleFormatter = DecimalFormat.getNumberInstance(Locale.US);
        setValue(value);
    }

	/**
	 * get the double value of this field 
	 * @return the value of the field as a double
	 */
    public final double getValue() {
        double retVal = 0.00;
        try {
            retVal = doubleFormatter.parse(getText()).doubleValue();
        } catch (ParseException e) {
            // This should never happen because insertString allows
            // only properly formatted data to get in the field.
            toolkit.beep();
        }
        return retVal;
    }

	/**
	 * set the value of this field to a given double
	 * @param value the double to render
	 */
    public final void setValue(double value) {
        setText(doubleFormatter.format(value));
    }

	/**
	 * part of the java spec 
	 * @return description
	 */
    protected final Document createDefaultModel() {
        return new DoubleNumberDocument();
    }

	/**
	 * this class is part of the java trickery to render  
	 */
    protected class DoubleNumberDocument extends PlainDocument {
        public void insertString(int offs, 
                                 String str,
                                 AttributeSet a) 
                throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;

            for (int i = 0; i < result.length; i++) {
                if (Character.isDigit(source[i]) || (source[i] == '.'))
                    result[j++] = source[i];
                else {
                    toolkit.beep();
                    System.err.println("insertString: " + source[i]);
                }
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}
