package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class the table model for the forecast table
 */
public class ForecastTableModel extends AbstractTableModel {
	public final static String[] columnNames =
		{ 	"Forecast", "Scenario", "Submitted", 
			"Total Revenue", "Total Profit", "Profit Margin", "Close Date", 
			"Jan", "Feb", "Mar", "Q1", "Apr", "May", "Jun", "Q2", 
			"Jul", "Aug", "Sep", "Q3", "Oct", "Nov", "Dec", "Q4" };

	
	private ArrayList wholeList = null;
	private Forecast sample = new Forecast();

	/**
	 * construct the table model 
	 * @param wholeList the ArrayList of Forecasts to display
	 */
	public ForecastTableModel(ArrayList wholeList) {

		this.wholeList = wholeList;
		sample.setName("hi");
		sample.setScenario(Forecast.SCEN_BEST_CASE);
		sample.setSubmitted(new Boolean(true));
		sample.setRevenue(new Integer(1));
		sample.setProfit(new Integer(1));
		sample.setMargin(new Double(1.00));
		sample.setCloseDate(new Date());
		sample.setAmountJan(new Integer(0));
		sample.setAmountFeb(new Integer(0));
		sample.setAmountMar(new Integer(0));
		sample.setQ1(new Integer(0));
		sample.setAmountApr(new Integer(0));
		sample.setAmountMay(new Integer(0));
		sample.setAmountJun(new Integer(0));
		sample.setQ2(new Integer(0));
		sample.setAmountJul(new Integer(0));
		sample.setAmountAug(new Integer(0));
		sample.setAmountSep(new Integer(0));
		sample.setQ3(new Integer(0));
		sample.setAmountOct(new Integer(0));
		sample.setAmountNov(new Integer(0));
		sample.setAmountDec(new Integer(0));
		sample.setQ4(new Integer(0));

		setLang();
	}

	/**
	 * add a Forecast to the model 
	 * @param f the Forecast to add
	 */
	public final void addForecast(Forecast f) {
		wholeList.add(f);
	}

	/**
	 * get the Forecast at a given index 
	 * @param index the index 
	 * @return the Forecast
	 */
	public final Forecast getForecast(int index) {
		return (Forecast)(wholeList.get(index));
	}

	/**
	 * delete a forecast from the model 
	 * @param index the forecast index to delete
	 */
	public final void deleteForecast(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the model's list of Forecasts 
	 * @return the ArrayList of Forecasts
	 */
	public final ArrayList getForecasts() { 
		return wholeList;
	}

	/**
	 * get a table cell's value 
	 * @param inRow the row index
	 * @param col the column index
	 * @return  the value at that cell
	 */
	public final Object getValueAt(int inRow, int col) {
		Forecast row = (Forecast)wholeList.get(inRow);
		switch (col) {
			case 0: //name
				return row.getName();
			case 1: //scenario
				return row.getScenario();
			case 2: //submitted
				return row.getSubmitted();
			case 3: //revenue
				return row.getRevenue();
			case 4: //profit
				return row.getProfit();
			case 5: //margin
				return row.getMargin();
			case 6: //close date
				return row.getCloseDate();
			case 7: //Jan amount
				return row.getAmountJan();
			case 8: //Feb amount
				return row.getAmountFeb();
			case 9: //Mar amount
				return row.getAmountMar();
			case 10: //Q1 amount
				return row.getQ1();
			case 11: //Apr amount
				return row.getAmountApr();
			case 12: //May amount
				return row.getAmountMay();
			case 13: //Jun amount
				return row.getAmountJun();
			case 14: //Q2 amount
				return row.getQ2();
			case 15: //Jul amount
				return row.getAmountJul();
			case 16: //Aug amount
				return row.getAmountAug();
			case 17: //Sep amount
				return row.getAmountSep();
			case 18: //Q3 amount
				return row.getQ3();
			case 19: //Oct amount
				return row.getAmountOct();
			case 20: //Nov amount
				return row.getAmountNov();
			case 21: //Dec amount
				return row.getAmountDec();
			case 22: //Q4 amount
				return row.getQ4();
			default:
				System.out.println("oops its dorked");
				break;
		}

		Exception e = new Exception();
		e.printStackTrace();
		System.exit(1);
		return null;	
	}

	/**
	 * part of the standard interface
	 */
	public final int getRowCount() {
		return wholeList.size();
	}

	/**
	 * part of the standard interface
	 */
	public final int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * part of the standard interface
	 */
	public final String getColumnName(int col) {
		return columnNames[col];
	}

	/**
	 * part of the standard interface
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //name
				return sample.getName().getClass();
			case 1: //scenario
				return sample.getScenario().getClass();
			case 2: //submitted
				return sample.getSubmitted().getClass();
			case 3: //revenue
				return sample.getRevenue().getClass();
			case 4: //profit
				return sample.getProfit().getClass();
			case 5: //margin
				return sample.getMargin().getClass();
			case 6: //close date
				return sample.getCloseDate().getClass();
			case 7: //jan  amounts
			case 8: //feb amounts
			case 9: //mar amounts
			case 10: //Q1 amount
			case 11: //apr amounts
			case 12: //may amounts
			case 13: //jun amounts
			case 14: //Q2
			case 15: //jul amounts
			case 16: //aug amounts
			case 17: //sep amounts
			case 18: //Q3
			case 19: //oct amounts
			case 20: //nov amounts
			case 21: //dec amounts
			case 22: //Q4
				return sample.getAmountJan().getClass();
			default:
				System.out.println("oops its dorked");
				break;
		}
		Exception e = new Exception();
		e.printStackTrace();
		System.exit(0);
		return null;
	}	
	
	/**
	 * part of the standard interface
	 */
	public final void setValueAt(Object value, int row, int col) {
		Forecast f = (Forecast)wholeList.get(row);
		switch (col) {
			case 0: //name
				f.setName((String)value);
				break;
			case 1: //scenario
				f.setScenario((String)value);
				break;
			case 2: //submitted
				f.setSubmitted((Boolean)value);
				break;
			case 3: //revenue
				f.setRevenue((Integer)value);
				break;
			case 4: //profit
				f.setProfit((Integer)value);
				break;
			case 5: //margin
				Double dd = (Double)value;
				if (dd.doubleValue() > 100.00)
					System.out.println("setting margin too high");
				f.setMargin((Double)value);
				break;
			case 6: //close date
				if (value == null) value = new Date();
				f.setCloseDate((Date)value);
				break;
			case 7: //jan amt
				f.setAmountJan((Integer)value);
				break;
			case 8: //Feb amt
				f.setAmountFeb((Integer)value);
				break;
			case 9: //Mar amt
				f.setAmountMar((Integer)value);
				break;
			case 10: //Q1
				f.setQ1((Integer)value);
				break;
			case 11: //Apr amt
				f.setAmountApr((Integer)value);
				break;
			case 12: //May amt
				f.setAmountMay((Integer)value);
				break;
			case 13: //Jun amt
				f.setAmountJun((Integer)value);
				break;
			case 14: //Q2
				f.setQ2((Integer)value);
				break;
			case 15: //Jul amt
				f.setAmountJul((Integer)value);
				break;
			case 16: //Aug amt
				f.setAmountAug((Integer)value);
				break;
			case 17: //Sep amt
				f.setAmountSep((Integer)value);
				break;
			case 18: //Q3
				f.setQ3((Integer)value);
				break;
			case 19: //Oct amt
				f.setAmountOct((Integer)value);
				break;
			case 20: //Nov amt
				f.setAmountNov((Integer)value);
				break;
			case 21: //dec amt
				f.setAmountDec((Integer)value);
				break;
			case 22: //Q4
				f.setQ4((Integer)value);
				break;
			default:
				System.out.println("oops its dorked");
				break;
		}

		//fireTableCellUpdated(row, col);
		fireTableRowsUpdated(row, row);
	}

	/**
	 * part of the standard interface
	 */
	public final boolean isCellEditable(int row, int col) {
		//dont allow totals to be edited
		if ((col == 3) || (col == 4))
			return false;

		//dont allow table editing of the submitted flag this forces
		//the user to use the menu button to perform the submit, this
		//is safer than letting them edit this table col directly
		if (col == 2)
			return false;

		//if submitted == true then don't allow any col to be edited
		Boolean submitted = (Boolean)(getValueAt(row, 2));
		if (submitted.booleanValue() == true)
			return false;

	
		//dont allow editing of the Q1-Q4 amounts
		if ( ( col == 10) || (col == 14) || (col == 18) || (col == 22))
			return false;

		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		return  true;
	}

	/**
	 * set the table's language 
	 */
	public final void setLang() {

		Whiteboard wb = MainWindow.getWhiteboard();

		columnNames[0] = wb.getLang().getString("forecast");
		columnNames[1] = wb.getLang().getString("scenario");
		columnNames[2] = wb.getLang().getString("submitted");
		columnNames[3] = wb.getLang().getString("totalRev");
		columnNames[4] = wb.getLang().getString("totalProfit");
		columnNames[5] = wb.getLang().getString("profitMargin");
		columnNames[6] = wb.getLang().getString("closeDate");
		columnNames[7] = wb.getLang().getString("jan");
		columnNames[8] = wb.getLang().getString("feb");
		columnNames[9] = wb.getLang().getString("mar");
		columnNames[10] = wb.getLang().getString("Q1");
		columnNames[11] = wb.getLang().getString("apr");
		columnNames[12] = wb.getLang().getString("may");
		columnNames[13] = wb.getLang().getString("jun");
		columnNames[14] = wb.getLang().getString("Q2");
		columnNames[15] = wb.getLang().getString("jul");
		columnNames[16] = wb.getLang().getString("aug");
		columnNames[17] = wb.getLang().getString("sep");
		columnNames[18] = wb.getLang().getString("Q3");
		columnNames[19] = wb.getLang().getString("oct");
		columnNames[20] = wb.getLang().getString("nov");
		columnNames[21] = wb.getLang().getString("dec");
		columnNames[22] = wb.getLang().getString("Q4");
	}
}
