package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class provides the lead table model
 * used in the leads dialog
 */
public class LeadTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Contact", "Company", "Phone No.", "Interest Level", "Contacted By",
		"Notes", "Converted to Opp" };

	private ArrayList wholeList = null;
	private Lead lead = new Lead();

	/**
	 * construct the lead table model 
	 * @param wholeList the list of Leads to store
	 * in the table
	 */
	public LeadTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		Address a = new Address();
        lead.setAddress(a);
        lead.setCompany("EDS");
        lead.setInterestLevel("NONE");
		SalesPerson s = new SalesPerson();
        lead.setContactedBy(s);
        lead.setContactDate(new java.util.Date());
        lead.setConverted(new Boolean(false));
		setLang();
	}

	/**
	 * add a lead to the table's model 
	 * @param f the Lead to add
	 */
	public final void addLead(Lead f) {
		wholeList.add(f);
	}

	/**
	 * get a Lead from the table  
	 * @param index the lead index to use
	 * @return the Lead
	 */
	public final Lead getLead(int index) {
		return (Lead)(wholeList.get(index));
	}

	/**
	 * delete a lead from the model 
	 * @param index the lead index to delete with
	 */
	public final void deleteLead(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the leads from this model
	 * @return the list of Leads
	 */
	public final ArrayList getLeads() { 
		return wholeList;
	}

	/**
	 * part of the spec for table models 
	 */
	public Object getValueAt(int row, int col) {
		Lead lead=null;
		lead = (Lead)wholeList.get(row);
		switch (col) {
			case 0: //contact name
				return lead.getAddress().getFormattedName();
			case 1: //company
				return lead.getCompany();
			case 2: //phone number
				return lead.getAddress().getPhone();
			case 3: //interest level
				return lead.getInterestLevel();
			case 4: //contacted by
				return lead.getContactedBy().getAddress().getFormattedName();
			case 5: //contact date
				return lead.getContactDate();
			case 6: //converted flag
				return lead.getConverted();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}


	/**
	 * part of the spec for table models 
	 */
	public Class getColumnClass(int col) {
		switch (col) {
			case 0: //contact name
				return lead.getAddress().getFormattedName().getClass();
			case 1: //company
				//return lead.getCompany().getClass();
				return String.class;
			case 2: //phone number
				//return lead.getAddress().getPhone().getClass();
				return String.class;
			case 3: //interestLevel
				//return lead.getInterestLevel().getClass();
				return String.class;
			case 4: //contacted by
				//return lead.getContactedBy().getFormattedName().getClass();
				return String.class;
			case 5: //contact date
				return lead.getContactDate().getClass();
			case 6: //converted flag
				return lead.getConverted().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	

	/**
	 * not implemented cuz this table is read only	
	 * part of the spec for table models 
	 */
	public void setValueAt(Object value, int row, int col) {
		Lead f = null;
		f = (Lead)wholeList.get(row);
		switch (col) {
			case 0: //contact name
				break;
			case 1: //company
				break;
			case 2: //phone number
				break;
			case 3: //interest level
				break;
			case 4: //contacted by
				break;
			case 5: //contact date
				break;
			case 6: //converted flag
				break;
			default:
				System.out.println("oops its dorked");
				break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 * part of the table model spec 
	 */
	public boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		return  false;
	}

	/**
	 * part of the table model spec 
	 */
	public int getRowCount() {
		return wholeList.size();
	}

	/**
	 * part of the table model spec 
	 */
	public int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * part of the table model spec 
	 */
	public String getColumnName(int col) {
		return columnNames[col];
	}

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames[0] = wb.getLang().getString("contact");
		columnNames[1] = wb.getLang().getString("company");
		columnNames[2] = wb.getLang().getString("phone");
		columnNames[3] = wb.getLang().getString("interestLevel");
		columnNames[4] = wb.getLang().getString("contactedBy");
		columnNames[5] = wb.getLang().getString("notes");
		columnNames[6] = wb.getLang().getString("convertedToOpp");
	}
}
