package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;

import javax.swing.*;
import java.rmi.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class is the command line class that gets
 * executed, processes command line args, creates
 * the MainWindow, and displays the MainWindow.
 */
public class Main {
	public static void main(String args[]) {
		try {
			LogWrite.init();
			LogWrite.write("starting log");

			MainWindow  mainWindow = new MainWindow();
			WindowListener l = new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					LogWrite.close();
					System.exit(0);
				}
			};

			mainWindow.addWindowListener(l);
		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (AngError e) {
			e.printStackTrace();
		} finally {
		}
	}
}
