package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Opportunity tab panel
 * users see when they use the MainWindow GUI
 */
public class OppPanel extends JPanel 
	implements DateEditorDialogListener, GUIChars {

	private final static int STRUT_LEN=3;
	private CalendarDialog calendarDialog;
	private Whiteboard wb;

	private JLabel nameLabel = new JLabel();
	private JTextField name = new JTextField();

	private JLabel createDtLabel = new JLabel();
	private JTextField createDtField = new JTextField();

	private JLabel dollarValueLabel = new JLabel();
	private JTextField dollarValue = new JTextField("0");

	private JLabel createdByLabel = new JLabel("Created By");
	private JTextField createdByField = new JTextField("");

	private JLabel stageLabel = new JLabel();
	private JComboBox stage = new JComboBox(Opportunity.ALL_STAGES);

	private JLabel custLabel = new JLabel();
	private JComboBox custName = new JComboBox();

	private JLabel groupLabel = new JLabel();
	private JTextField groupField = new JTextField("");

	private JLabel primSalesLabel = new JLabel();
	private JComboBox primSalesman = new JComboBox();

	private JLabel probLabel = new JLabel();
	private JComboBox probability = new JComboBox(Opportunity.PROB);

 	private JLabel leadSrcLabel = new JLabel();
    private JComboBox leadSrcCombo = new JComboBox();

    private JLabel typeLabel = new JLabel();
    private JComboBox typeCombo = new JComboBox();

    private JLabel closeDateLabel = new JLabel();
    private JButton closeDtButton = new JButton();

	private JPanel descPanel = new JPanel();
    private JTextArea descTextArea = new JTextArea(15, 30);
	private JScrollPane descScrollPane = null;

	private JPanel teamPanel = new JPanel();
	private JScrollPane groupMembersScrollPane = null;
	private JList groupMembersList = new JList();

	private JButton applyButton = new JButton("Apply");

	private Vector groupNames = new Vector();

	/**
	 * construct the opp panel
	 */
	public OppPanel() {
		super(new BorderLayout());

		wb = MainWindow.getWhiteboard();

		calendarDialog = new CalendarDialog(MainWindow.getMainParent(), this, true);

		JPanel detailPanel = new JPanel();
		detailPanel.setBorder(new EtchedBorder());
        detailPanel.setLayout( new GridBagLayout());
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();

        nameLabel.setText("Name");
		nameLabel.setForeground(MainWindow.LETTERS);
        nameLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(nameLabel, gridBagConstraints2);

        name.setText("name");
        name.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        name.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        name.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(name, gridBagConstraints2);

        groupLabel.setText("Group");
		groupLabel.setForeground(MainWindow.LETTERS);
        groupLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(groupLabel, gridBagConstraints2);

        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
		groupField.setEditable(false);
        groupField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        groupField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        groupField.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        detailPanel.add(groupField, gridBagConstraints2);

        primSalesLabel.setText("Primary Sales Person");
        createDtLabel.setText("Created Date");
		createDtLabel.setForeground(MainWindow.LETTERS);
        createDtLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(createDtLabel, gridBagConstraints2);

        createDtField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        createDtField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        createDtField.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
		createDtField.setEditable(false);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(createDtField, gridBagConstraints2);

		createdByLabel.setForeground(MainWindow.LETTERS);
        createdByLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(createdByLabel, gridBagConstraints2);

        createdByField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        createdByField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        createdByField.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
		createdByField.setEditable(false);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(createdByField, gridBagConstraints2);

        stageLabel.setText("Sales Stage");
		stageLabel.setForeground(MainWindow.LETTERS);
        stageLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(stageLabel, gridBagConstraints2);

        stage.setName("sales stage");
        stage.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        stage.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        stage.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(stage, gridBagConstraints2);

        custLabel.setText("Customer");
		custLabel.setForeground(MainWindow.LETTERS);
        custLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(custLabel, gridBagConstraints2);

        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 2;
        custName.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        custName.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        custName.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(custName, gridBagConstraints2);



        dollarValueLabel.setText("Dollar Value");
		dollarValueLabel.setForeground(MainWindow.LETTERS);
        dollarValueLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		primSalesLabel.setForeground(MainWindow.LETTERS);
        primSalesLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(primSalesLabel, gridBagConstraints2);

		primSalesman.setName("prime sales");
        primSalesman.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        primSalesman.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        primSalesman.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(primSalesman, gridBagConstraints2);

        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(dollarValueLabel, gridBagConstraints2);

        dollarValue.setText("dollar value");
        dollarValue.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        dollarValue.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        dollarValue.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(dollarValue, gridBagConstraints2);
		dollarValue.addFocusListener(
			new FocusListener() {
				public void focusGained(FocusEvent e) { }
				public void focusLost(FocusEvent e) {
					int x = Integer.parseInt(dollarValue.getText());
					dollarValue.setText(Prefs.wholeMoney.format(x));
				}
			}
		);

        probLabel.setText("Probability");
		probLabel.setForeground(MainWindow.LETTERS);
        probLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(probLabel, gridBagConstraints2);

        probability.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        probability.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        probability.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(probability, gridBagConstraints2);

        closeDateLabel.setText("Close Date");
        closeDateLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);        
		gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.ipadx = 5;
        gridBagConstraints2.ipady = 5;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(closeDateLabel, gridBagConstraints2);

		Date dummy = new Date();
		closeDtButton.setHorizontalAlignment(SwingConstants.LEFT);
        closeDtButton.setText(Prefs.dateFormat.format(dummy));
		closeDtButton.setMargin(new Insets(0,0,0,0));
        closeDtButton.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        closeDtButton.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        closeDtButton.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(closeDtButton, gridBagConstraints2);

        leadSrcLabel.setText("Lead Source");
        leadSrcLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        detailPanel.add(leadSrcLabel, gridBagConstraints2);

        leadSrcCombo.setModel(new javax.swing.DefaultComboBoxModel(Opportunity.ALL_LEADS));
        leadSrcCombo.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        leadSrcCombo.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        leadSrcCombo.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
        detailPanel.add(leadSrcCombo, gridBagConstraints2);

        typeLabel.setText("Type");
        typeLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(typeLabel, gridBagConstraints2);

        typeCombo.setModel(new javax.swing.DefaultComboBoxModel(Opportunity.ALL_LEAD_TYPES));
        typeCombo.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        typeCombo.setMaximumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        typeCombo.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        detailPanel.add(typeCombo, gridBagConstraints2);


        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
		teamPanel.setBorder(new TitledBorder("Sales Team"));
		groupMembersScrollPane = new JScrollPane(groupMembersList);	
		//groupMembersScrollPane.setBorder(new TitledBorder("Sales Team"));
        groupMembersScrollPane.setPreferredSize(new Dimension(120, 90));
        groupMembersScrollPane.setMinimumSize(new Dimension(120, 90));
		groupMembersScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		groupMembersScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

		teamPanel.add(groupMembersScrollPane);
        //detailPanel.add(groupMembersScrollPane, gridBagConstraints2);
        detailPanel.add(teamPanel, gridBagConstraints2);

		add(detailPanel, BorderLayout.CENTER);
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        //gridBagConstraints2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
		descTextArea.setLineWrap(true);
		descTextArea.setWrapStyleWord(true);
		descTextArea.setRows(4);
		descTextArea.setColumns(50);
		descScrollPane = new JScrollPane(descTextArea);	
		//descScrollPane.setBorder(new TitledBorder("Description"));
        descScrollPane.setPreferredSize(new Dimension(200, 90));
        descScrollPane.setMinimumSize(new Dimension(200, 90));
		descScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		descScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

		descPanel.add(descScrollPane);
        //detailPanel.add(descScrollPane, gridBagConstraints2);
        detailPanel.add(descPanel, gridBagConstraints2);

		add(detailPanel, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		buttonPanel.add(applyButton);
		add(buttonPanel, BorderLayout.SOUTH);

		closeDtButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					calendarDialog.show();
				}
			}
		);

		applyButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					updateOpportunity();
				}
			}
		);

		setColors();
		setFonts();
		setLang();
	}

	/**
	 * load the info into the panel 
	 */
	public final void load() {
		try {
			loadCustomerList();
			ArrayList persons = wb.getSalesPersonNames();
			primSalesman.setModel(
				new DefaultComboBoxModel(persons.toArray()) );
		} catch (Exception e) {
			ErrorHandler.show(this, e);
		}
	}

	/**
	 * lod the customer list info 
	 */
   	public final void loadCustomerList() {
		try { 
        	TreeMap allNames = wb.getAllCustNames(false);
			custName.setModel(new DefaultComboBoxModel(
				allNames.values().toArray()));
		} catch (AngError e) {
			ErrorHandler.show(this, e);
		}
    }

	/**
	 * enable or disable the panel's fields 
	 * @param t true or false
	 */
	public final void setEnabled(boolean t) {
		 name.setEnabled(t);
		 createDtField.setEnabled(t);
		 dollarValue.setEnabled(t);
		 probability.setEnabled(t);
		 stage.setEnabled(t);
		 custName.setEnabled(t);
		 groupField.setEnabled(t);
		 primSalesman.setEnabled(t);
	}

	/**
	 * update the current opportunity 
	 */
	public final void updateOpportunity() {
		Opportunity opp = wb.getCurrentOpportunity();
		opp.setName(name.getText());
		Number num = Prefs.wholeMoney.parse(dollarValue.getText(), new ParsePosition(0));
		opp.setDollarValue(num.intValue());
		opp.setDesc(descTextArea.getText());
		opp.setProbability((String)(probability.getSelectedItem()));
		opp.setStage((String)stage.getSelectedItem());
		opp.setLeadSource((String)leadSrcCombo.getSelectedItem());
		opp.setLeadType((String)typeCombo.getSelectedItem());
		//look up the customer
		try {
			Customer c = wb.getCustomer((String)custName.getSelectedItem());
			opp.setCustomer(c);
		} catch (AngError e) {
			ErrorHandler.show(this, e);
		}

		int index = primSalesman.getSelectedIndex();
		try {
			TreeMap allSPs = wb.getSalesPersons();
			Object[] values = allSPs.values().toArray();
			SalesPerson p = (SalesPerson)values[index];
			opp.setPrimeSalesPerson(p);

			wb.setCurrentOpportunity(opp);
			wb.updateOpportunity(opp);
			MainWindow.refreshOpportunity(); //refresh all screens
		} catch (AngError ae) {
			ErrorHandler.show(this, ae);
		}
	}


	/**
	 * set the panel to the current opportunity 
	 */
	public final void refreshOpportunity() {
		Opportunity opp = wb.getCurrentOpportunity();
		Utility.strSet(name, opp.getName());
		Utility.strSet(groupField, opp.getGroupName());
		Utility.strSet(descTextArea, opp.getDesc());
		createDtField.setText(Prefs.dateFormat.format(opp.getModifiedDate()));
		closeDtButton.setText(Prefs.dateFormat.format(opp.getCloseDate()));
		createdByField.setText(opp.getModifiedBy());
		Utility.strSet(dollarValue, Prefs.wholeMoney.format(opp.getDollarValue()));
		probability.setSelectedItem(opp.getProbability());
		Utility.comboSet(stage, opp.getStage());
		Utility.comboSet(typeCombo, opp.getLeadType());
		Utility.comboSet(leadSrcCombo, opp.getLeadSource());

		if (opp.getCustomer() != null) {
			Utility.comboSet(custName, opp.getCustomer().getName());
		} else {
			Exception x = new Exception();
			x.printStackTrace();
		}

		try {
			TreeMap users = wb.getUsersInGroup(opp.getGroupName());
			Object[] keys = users.keySet().toArray();
			groupMembersList.setListData(keys);
			groupMembersList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

			TreeMap allSPs = wb.getSalesPersons();
			Object[] values = allSPs.values().toArray();
			SalesPerson sp = null;
			if (opp.getPrimeSalesPerson() != null) {
				for (int i=0;i<allSPs.size();i++) {
					sp = (SalesPerson)values[i];
					if (sp.getID().equals(opp.getPrimeSalesPerson().getID())) {
						Utility.comboSet(primSalesman, sp.getID());
					}
				}
			} 

			if (opp.getPrimeSalesPerson() == null)
				;
			else
				Utility.comboSet(primSalesman, opp.getPrimeSalesPerson().getAddress().getFormattedName());

		} catch (AngError e) {
			ErrorHandler.show(this, e);
		}
	}

	/**
	 * set the panel's colors  
	 */
	public final void setColors() {
		int labels=0,fields=0,buttons=0;
		Component[] components = getComponents();
		for (int i=0;i<components.length;i++) {
			if (components[i] instanceof JLabel)
				labels++;
			else
			if (components[i] instanceof JTextField)
				fields++;
			else
			if (components[i] instanceof JButton)
				buttons++;
		}

 		nameLabel.setForeground(MainWindow.LETTERS);
        createDtLabel.setForeground(MainWindow.LETTERS);
        dollarValueLabel.setForeground(MainWindow.LETTERS);
        stageLabel.setForeground(MainWindow.LETTERS);
        custLabel.setForeground(MainWindow.LETTERS);
        primSalesLabel.setForeground(MainWindow.LETTERS);
        probLabel.setForeground(MainWindow.LETTERS);
		probability.setBackground(Color.white);
 		leadSrcLabel.setForeground(MainWindow.LETTERS);
 		createdByLabel.setForeground(MainWindow.LETTERS);
    	typeLabel.setForeground(MainWindow.LETTERS);
    	closeDateLabel.setForeground(MainWindow.LETTERS);
    	closeDtButton.setBackground(Color.white);
    	groupLabel.setForeground(MainWindow.LETTERS);
    	stage.setBackground(Color.white);
    	primSalesman.setBackground(Color.white);
    	custName.setBackground(Color.white);
    	leadSrcCombo.setBackground(Color.white);
    	typeCombo.setBackground(Color.white);
	}

	/**
	 * set the panel's fonts
	 */
	public final void setFonts() {
        leadSrcLabel.setFont(MainWindow.LABEL_FONT);
   		nameLabel.setFont(MainWindow.LABEL_FONT);
        name.setFont(MainWindow.FIELD_FONT);
        createDtLabel.setFont(MainWindow.LABEL_FONT);
        createDtField.setFont(MainWindow.FIELD_FONT);
        dollarValueLabel.setFont(MainWindow.LABEL_FONT);
        dollarValue.setFont(MainWindow.FIELD_FONT);
        stageLabel.setFont(MainWindow.LABEL_FONT);
        stage.setFont(MainWindow.FIELD_FONT);
        custLabel.setFont(MainWindow.LABEL_FONT);
        custName.setFont(MainWindow.FIELD_FONT);
        primSalesLabel.setFont(MainWindow.LABEL_FONT);
        primSalesman.setFont(MainWindow.FIELD_FONT);
        probLabel.setFont(MainWindow.LABEL_FONT);
        probability.setFont(MainWindow.FIELD_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
    	leadSrcCombo.setFont(MainWindow.FIELD_FONT);
    	typeCombo.setFont(MainWindow.FIELD_FONT);
    	closeDtButton.setFont(MainWindow.FIELD_FONT);
    	descTextArea.setFont(MainWindow.FIELD_FONT);
        groupLabel.setFont(MainWindow.LABEL_FONT);
        closeDateLabel.setFont(MainWindow.LABEL_FONT);
        typeLabel.setFont(MainWindow.LABEL_FONT);
        createdByLabel.setFont(MainWindow.LABEL_FONT);
    	createdByField.setFont(MainWindow.FIELD_FONT);
	}

	/**
	 * this is a callback that gets the date from the
	 * CalendarDialog after the user selects a date
	 * @param d the date to set to
	 */
	public final void setDate(Date d) {
		closeDtButton.setText(Prefs.dateFormat.format(d));
		Opportunity opp = wb.getCurrentOpportunity();
		opp.setCloseDate(d);
	}

	/**
	 * clear the screen 
	 */
	public final void clearOpportunity() {
		Utility.strSet(name, null);
		Utility.strSet(groupField, null);
		Utility.strSet(descTextArea, null);
		createDtField.setText("");
		closeDtButton.setText("");
		createdByField.setText("");
		Utility.strSet(dollarValue, null);
		probability.setSelectedIndex(0);
		stage.setSelectedIndex(0);
		typeCombo.setSelectedIndex(0);
		leadSrcCombo.setSelectedIndex(0);
		custName.setSelectedIndex(0);
	}

	/**
	 * set the screen's language
	 */
	public final void setLang() {
        nameLabel.setText(wb.getLang().getString("name"));
        groupLabel.setText(wb.getLang().getString("group"));
        primSalesLabel.setText(wb.getLang().getString("primeSalesPerson"));
        createDtLabel.setText(wb.getLang().getString("createdDate"));
        stageLabel.setText(wb.getLang().getString("salesStage"));
        custLabel.setText(wb.getLang().getString("customer"));
        dollarValueLabel.setText(wb.getLang().getString("dollarValue"));
        probLabel.setText(wb.getLang().getString("probability"));
        closeDateLabel.setText(wb.getLang().getString("closeDate"));
        leadSrcLabel.setText(wb.getLang().getString("leadSource"));
        typeLabel.setText(wb.getLang().getString("type"));
		teamPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("salesTeam"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
		descPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("description"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
		applyButton.setText(wb.getLang().getString("apply"));
	}

	/**
	 * update the customer name list, and reset the current selection
	 * after the update to original value, this is done when
	 * someone adds a new customer, we want the new customer to show up
	 * in the customer combo box
	 */
	public final void updateCustomerList() {
		String currCustName = (String)custName.getSelectedItem();
		loadCustomerList();
		custName.setSelectedItem(currCustName);
	}
}
