package sellwin.gui;

import sellwin.domain.*;
import java.util.*;
import java.rmi.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Preferences Dialog
 * which is the container for the PrefsPanel.
 * Users see this dialog when they select the
 * 'Preferences' menu option on the MainWindow.
 * From the screen, users can set their user
 * preferences.
 */
public class PrefsDialog extends JDialog {
	private PrefsPanel prefsPanel = new PrefsPanel();
    private JButton applyButton = new JButton("Apply");
    private JButton closeButton = new JButton("Cancel");
	private JLabel statusLabel  = new JLabel("");
	private Whiteboard wb;

	/**
	 * construct a preferences dialog 
	 */
	public PrefsDialog() {
		super();

		wb = MainWindow.getWhiteboard();

		setLang();
		setSize(650, 272);
		setFonts();
		setColors();

		prefsPanel.setBorder(new EtchedBorder());
		getContentPane().setLayout(new BorderLayout());

		getContentPane().add(prefsPanel, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		buttonPanel.add(applyButton);
		buttonPanel.add(closeButton);
		getContentPane().add(buttonPanel, BorderLayout.SOUTH);

 		WindowListener l = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
			}

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };
 
        addWindowListener(l);

		getRootPane().setDefaultButton(applyButton);

		closeButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					hide();
				}
			});

		applyButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					prefsPanel.storeProps();		
					wb.setLang(prefsPanel.getLang());
					wb.getMainWindow().setLang();
					setLang();
				}
			});

		getRootPane().setDefaultButton(applyButton);

	}

	/**
	 * set the dilaog's fonts 
	 */
	public final void setFonts() {
    	applyButton.setFont(MainWindow.LABEL_FONT);
    	closeButton.setFont(MainWindow.LABEL_FONT);
	}

	public final void setColors() {}

	/**
	 * set the dialog's language
	 */
	public final void setLang() {
		prefsPanel.setLang();
		setTitle(wb.getLang().getString("prefs"));
    	applyButton.setText(wb.getLang().getString("apply"));
    	closeButton.setText(wb.getLang().getString("close"));
	}
}
