package sellwin.gui;

import sellwin.utils.*;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the user preferences
 * screen components.  Users use this panel
 * to set their user prefs.  This panel is
 * contained by the Preferences Dialog.
 */
public class PrefsPanel extends javax.swing.JPanel implements GUIChars {

	private Whiteboard wb=null;
    private String [] modes = {"Connected", "Disconnected"};
    private JLabel connLabel;
    private JComboBox connectionBox;
    private JLabel langLabel;
    private JComboBox langPref;
    private JLabel serverNameLabel, localDBLabel, localDBIDLabel, localDBPSWLabel;
    private JTextField serverNameField, localDBField, localDBIDField, localDBPSWField;

	public PrefsPanel() { 
        initComponents();
		wb = MainWindow.getWhiteboard();
		setFonts();
		setLang();
		getProps();
		setColors();

    }

    /** 
	 * This method is called from within the constructor to
     * initialize the form.
     */
    private final void initComponents() {
        connLabel = new JLabel();
        connectionBox = new JComboBox(modes);
        langLabel = new JLabel();
        langPref = new JComboBox(Prefs.LANGS);
        localDBLabel = new JLabel();
        localDBField = new JTextField();
        localDBIDLabel = new JLabel();
        localDBIDField = new JTextField();
        localDBPSWLabel = new JLabel();
        localDBPSWField = new JTextField();
        serverNameLabel = new JLabel();
        serverNameField = new JTextField();
	
        
        
        setLayout(new java.awt.GridBagLayout());
		setBorder(new EtchedBorder());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        connLabel.setText("Connection Mode");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(connLabel, gridBagConstraints1);
        
        connectionBox.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        connectionBox.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 5;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(connectionBox, gridBagConstraints1);
        
        langLabel.setText("Language");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(langLabel, gridBagConstraints1);
        
        langPref.setPreferredSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        langPref.setMinimumSize(new Dimension(140, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(langPref, gridBagConstraints1);
        
        localDBLabel.setText("Local DB");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBLabel, gridBagConstraints1);
        
        localDBField.setText("jTextField1");
        localDBField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        localDBField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBField, gridBagConstraints1);

        localDBIDLabel.setText("Local DB ID");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBIDLabel, gridBagConstraints1);
        
        localDBIDField.setText("jTextField1");
        localDBIDField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        localDBIDField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBIDField, gridBagConstraints1);
        
        localDBPSWLabel.setText("Local DB PSWID");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBPSWLabel, gridBagConstraints1);
        
        localDBPSWField.setText("jTextField1");
        localDBPSWField.setPreferredSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        localDBPSWField.setMinimumSize(new Dimension(200, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(localDBPSWField, gridBagConstraints1);
        
        
        serverNameLabel.setText("Server");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(serverNameLabel, gridBagConstraints1);
        
        serverNameField.setText("jTextField2");
        serverNameField.setPreferredSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        serverNameField.setMinimumSize(new Dimension(120, Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.ipadx = 2;
        gridBagConstraints1.ipady = 2;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP, Prefs.I_LF, Prefs.I_BOTT, Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(serverNameField, gridBagConstraints1);
        
    }


    /**
     * store the properties that define the preferences
     */
    public final void storeProps() {

        Properties props = new Properties();
        props.setProperty(Prefs.DEF_LANG, (String)langPref.getSelectedItem());

        String mode = (String)connectionBox.getSelectedItem();
        if (mode.equals(modes[0]))
            props.setProperty(Prefs.CONN_MODE, Prefs.CONNECTED);
        else
            props.setProperty(Prefs.CONN_MODE, Prefs.LOCAL);

        props.setProperty(Prefs.LOCAL_DB, localDBField.getText());
        props.setProperty(Prefs.LOCAL_DB_ID, localDBIDField.getText());
        props.setProperty(Prefs.LOCAL_DB_PSW, localDBPSWField.getText());

        props.setProperty(Prefs.SERVER_NAME, serverNameField.getText());

        Prefs.saveApplProps(props);
    }


    /**
     * set the properties on the dialog 
     */
    public final void setPropsOnScreen() {
        Properties props = wb.getProps();
        String spd = (String)(props.getProperty(Prefs.CONN_MODE));
        if (spd.equals(Prefs.CONNECTED))
            connectionBox.setSelectedItem(modes[0]);
        else
            connectionBox.setSelectedItem(modes[1]);

        String db = (String)(props.getProperty(Prefs.LOCAL_DB));
        localDBField.setText(db);
        String id = (String)(props.getProperty(Prefs.LOCAL_DB_ID));
        localDBIDField.setText(id);
        String psw = (String)(props.getProperty(Prefs.LOCAL_DB_PSW));
        localDBPSWField.setText(psw);

        String lang = (String)(props.getProperty(Prefs.DEF_LANG));
        langPref.setSelectedItem(lang);

        String serverName = (String)(props.getProperty(Prefs.SERVER_NAME));
        if (serverName == null) {
			System.out.println("setting server to localhost");
            serverName = "localhost";
		}
        serverNameField.setText(serverName);


    }

    
    /**
     * get the properties from disk 
     */
    public final void getProps() {
        Properties props = wb.getProps();
        setPropsOnScreen();
    }

    /**
     * set the dialog's colors 
     */
    public final void setColors() {
        langLabel.setForeground(MainWindow.LETTERS);
        connLabel.setForeground(MainWindow.LETTERS);
        localDBLabel.setForeground(MainWindow.LETTERS);
        localDBIDLabel.setForeground(MainWindow.LETTERS);
        localDBPSWLabel.setForeground(MainWindow.LETTERS);
        serverNameLabel.setForeground(MainWindow.LETTERS);
        langPref.setBackground(Color.white);
        connectionBox.setBackground(Color.white);
                                                              

   }

    /**
     * set the dialog's fonts 
     */
    public final void setFonts() {
        connectionBox.setFont(MainWindow.FIELD_FONT);
        connLabel.setFont(MainWindow.LABEL_FONT);
        langLabel.setFont(MainWindow.LABEL_FONT);
        langPref.setFont(MainWindow.FIELD_FONT);
        localDBLabel.setFont(MainWindow.LABEL_FONT);
        localDBIDLabel.setFont(MainWindow.LABEL_FONT);
        localDBPSWLabel.setFont(MainWindow.LABEL_FONT);
        localDBField.setFont(MainWindow.FIELD_FONT);
        localDBIDField.setFont(MainWindow.FIELD_FONT);
        localDBPSWField.setFont(MainWindow.FIELD_FONT);
        serverNameLabel.setFont(MainWindow.LABEL_FONT);
        serverNameField.setFont(MainWindow.FIELD_FONT);
    }

    /**
     * get the current language setting
     * @return the language setting from the language combo box
     */
    public final String getLang() {
        return (String)langPref.getSelectedItem();
    }

    /**
     set the dialogs language
     */
    public final void setLang() {
        connLabel.setText(wb.getLang().getString("connectionType"));
        langLabel.setText(wb.getLang().getString("lang"));
        localDBLabel.setText(wb.getLang().getString("localDB"));
        localDBIDLabel.setText(wb.getLang().getString("localDBID"));
        localDBPSWLabel.setText(wb.getLang().getString("localDBPSW"));
        serverNameLabel.setText(wb.getLang().getString("serverName"));
    }
}
