package sellwin.gui;

import sellwin.domain.*;
import java.util.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class represenst the product table model
 * see the java spec for details on table models
 * within the Swing API
 */
public class ProductTableModel extends DefaultTableModel {
	private ArrayList rows;
	private ArrayList columnNames;

	/**
	 * constructa  product table model using 
	 * an array of product data
	 * @param r the list of data to build the 
	 * model around
	 */
	public ProductTableModel(ArrayList r) {
		setLang();
		rows = r;
	}

	/**
	 * get the product list data
	 * @return the list of product this model uses
	 */
	public final ArrayList getRows() {
		return rows;
	}

	/**
	 * remote a row  
	 * @param rowIndex row number to delete
	 */
	public final void removeRowByIndex(int rowIndex) {
		rows.remove(rowIndex);
		fireTableRowsDeleted(rowIndex, rowIndex);
	}

	/**
	 * remote a row  
	 */
	public final void removeRowObject(Object rowObject) {
		removeRowByIndex(rows.indexOf(rowObject));
	}

	/**
	 * set the rows to a list of objects 
	 * @param r the new row data
	 */
	public final void setRows(ArrayList r) {
		rows = r;
	}

	/**
	 *  see the spec
	 */
	public final int getColumnCount() {
		if (columnNames == null)
			return 0;
		else
			return columnNames.size();
	}

	/**
	 * see the spec 
	 */
	public final int getRowCount() {
		if (rows == null)
			return 0;
		else
			return rows.size();
	}

	/**
	 * see the spec 
	 */
	public final String getColumnName(int col) {
		if (columnNames != null && col < columnNames.size()) 
			return (String) columnNames.get(col);
		else
			return super.getColumnName(col);
	}

	/**
	 * see the spec 
	 */
	public final Object getValueAt(int row, int col) {
		ArrayList rows = getRows();

		if (rows != null && row < rows.size()) {
			CustomerInventory line = (CustomerInventory)rows.get(row);

			if (line != null) {
				if (col == 0) {	
					return line.getProduct().getName();
				}
				if (col == 1) {
					return line.getCount();
				}
			}
		}

		return null;
	}

	/**
	 * set the screen language 
	 */
	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames = new ArrayList();
		columnNames.add(wb.getLang().getString("product"));
		columnNames.add(wb.getLang().getString("count"));
	}
}
