package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the table model for the quote line
 * items table on the quotes panel.  This class determines 
 * how table rows are mapped to quote line item objects.
 */
public class QuoteLineTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Product Name", "Qty", "Model No.", "Cost", "Unit Price",
		"Total Price", "Description" };

	private ArrayList wholeList = null;
	private QuoteLine quote = new QuoteLine();

	/**
	 * create the quote line table model
	 * @param wholeList the array of objects that we use
	 * to populate the table 
	 */
	public QuoteLineTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		Product prod = new Product();
		prod.setName("hi");
		quote.setProduct(prod);
		quote.setQuantity(new Integer(10));
		prod.setModelNo("1234");
		prod.setCost(new Double(1.99));
		prod.setPrice(new Double(10.88));
		prod.setDesc("desc");

		setLang();
	}

	/**
	 * add a quote line to the table's list of objects 
	 * @param f the QuoteLine object to add
	 */
	public final void addQuoteLine(QuoteLine f) {
		wholeList.add(f);
	}

	/**
	 * get a QuoteLine using an index key value 
	 * @param index the index key value
	 * @return the found QuoteLine
	 */
	public final QuoteLine getQuoteLine(int index) {
		return (QuoteLine)(wholeList.get(index));
	}

	/**
	 * delete a QuoteLine from the current array  
	 * @param index the index key 
	 */
	public final void deleteQuoteLine(int index) {
		wholeList.remove(index);
	}

	/**
	 * get an array of QuoteLines used by the table 
	 * @return the ArrayList of QuoteLines
	 */
	public final ArrayList getQuoteLines() { 
		return wholeList;
	}

	/**
	 * get a table value at a given row and column 
	 * @param row the row index to search
	 * @param col the column index to search 
	 * @return the found Object 
	 */
	public final Object getValueAt(int row, int col) {
		QuoteLine quote=null;
		quote = (QuoteLine)wholeList.get(row);
		switch (col) {
			case 0: //product name
				return quote.getProduct().getName();
			case 1: //quantity
				return quote.getQuantity();
			case 2: //model number
				return quote.getProduct().getModelNo();
			case 3: //cost
				return quote.getProduct().getCost();
			case 4: //price
				return quote.getProduct().getPrice();
			case 5: //description
				return quote.getTotalPrice();
			case 6: //description
				return quote.getProduct().getDesc();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 * get the number of objects we are displaying
	 * @return the table size
	 */
	public final int getRowQuantity() {
		return wholeList.size();
	}

	/**
	 * get the column count of the table 
	 * @return the column count
	 */
	public final int getColumnQuantity() {
		return columnNames.length;
	}


	/**
	 * get the class of a table column 
	 * @param col the column index
	 * @return the Class of the column
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //product name
				return quote.getProduct().getName().getClass();
			case 1: //quantity
				return quote.getQuantity().getClass();
			case 2: //model number
				return quote.getProduct().getModelNo().getClass();
			case 3: //cost
				return quote.getProduct().getCost().getClass();
			case 4: //price
				return quote.getProduct().getPrice().getClass();
			case 5: //total
				return quote.getTotalPrice().getClass();
			case 6: //description
				return quote.getProduct().getDesc().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 * set a table's cell value 
	 * @param value the value we are setting
	 * @param row the row index 
	 * @param col the column index 
	 */
	public final void setValueAt(Object value, int row, int col) {
		QuoteLine q = (QuoteLine)wholeList.get(row);
		q.setModified(true);
		switch (col) {
			case 0: //product name
				q.getProduct().setName((String)value);
				break;
			case 1: //quantity
				q.setQuantity((Integer)value);
				break;
			case 2: //model number
				q.getProduct().setModelNo((String)value);
				break;
			case 3: //cost
				q.getProduct().setCost((Double)value);
				break;
			case 4: //price
				q.getProduct().setPrice((Double)value);
				break;
			case 5: //total
				q.setTotalPrice((Double)value);
				break;
			case 6: //description
				q.getProduct().setDesc((String)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 * check to see if a table's cell is editable 
	 * @param row the row index
	 * @param col the col index
	 * @return true if the cell is editable
	 */
	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		if (col != 1)
			return false;

		return  true;
	}

	/**
	 * get the count of colnms in the table 
	 * @return the column count
	 */
 	public final int getColumnCount() {
        return columnNames.length;
    }

	/**
	 * get a column's name 
	 * @param col the column index
	 * @return the name of the column
	 */
    public final String getColumnName(int col) {
        return columnNames[col];
    }

	/**
	 * get the row count 
	 * @return the number of rows in the table
	 */
  	public final int getRowCount() {
        return wholeList.size();
    }

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames[0] = wb.getLang().getString("productName");
		columnNames[1] = wb.getLang().getString("qty");
		columnNames[2] = wb.getLang().getString("model");
		columnNames[3] = wb.getLang().getString("cost");
		columnNames[4] = wb.getLang().getString("unitPrice");
		columnNames[5] = wb.getLang().getString("total");
		columnNames[6] = wb.getLang().getString("description");
	}
}
