package sellwin.gui;

import sellwin.domain.*;
import sellwin.server.*;
import sellwin.utils.*;

import java.util.*;
import java.rmi.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the user maintenance
 * dialog which is viewable via the Admin menu
 * option on the MainWindow.
 */
public class SalesPersonDialog extends JDialog implements GUIChars {
	private Whiteboard wb;
	private JDialog thisDialog = null;

	private ArrayList currentRoles=null;
	private ArrayList roleNamesList=new ArrayList();
	private JPanel userPanel = new JPanel();
	private JList userList = new JList();
	private JLabel userIDLabel = new JLabel("User ID");
	private JTextField id = new JTextField(20);
	private JLabel passwordLabel = new JLabel("Password");
	private JTextField password = new JTextField(20);
	private ArrayList roles = new ArrayList();
	private JPanel rolePanel = new JPanel();
	private JLabel roleListLabel = new JLabel("Roles");
	private JList roleList = new JList();

	private JPopupMenu rolePopup = new JPopupMenu();
	private JMenuItem addRoleMenuItem = new JMenuItem("Add");
	private JMenuItem deleteRoleMenuItem = new JMenuItem("Delete");

	private JLabel addressLabel = new JLabel("Address");
	private AddressPanel addressPanel = new AddressPanel();

	private JButton applyButton = new JButton("Apply");
	private JButton clearButton = new JButton("Clear");
	private JButton closeButton = new JButton("Cancel");

	private JPopupMenu userPopup = new JPopupMenu();
	private JScrollPane scrollPane3, scrollPane9;

	/**
	 * construct a sales person dialog 
	 */
	public SalesPersonDialog()  {

		super();

		thisDialog = this;
		wb = MainWindow.getWhiteboard();


		setSize(630,575);

		setFonts();
		setColors();

        getContentPane().setLayout(new BorderLayout());
 
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gbl);

        gbc = new GridBagConstraints();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.ipadx = 10;
		gbc.ipady = 10;
		userList.setVisibleRowCount(3);
		userList.setPrototypeCellValue("XXXXXXXXXXXXXXXXXX");
		userList.setMinimumSize(new Dimension(500,150));
		userList.setPreferredSize(new Dimension(500,150));
		scrollPane3 = new JScrollPane(userList);
		scrollPane3.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		scrollPane3.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		userPanel.add(scrollPane3);
        mainPanel.add(userPanel, gbc);

		JPanel idpswPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 1;
        mainPanel.add(idpswPanel, gbc);

        gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        idpswPanel.add(userIDLabel, gbc);

        gbc = new GridBagConstraints();
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 1;
		gbc.gridy = 0;
		idpswPanel.setMinimumSize(new Dimension(200,100));
		idpswPanel.setPreferredSize(new Dimension(200,100));
		idpswPanel.setMaximumSize(new Dimension(200,100));
		id.setMinimumSize(new Dimension(70,Prefs.FIELD_HEIGHT));
		id.setMaximumSize(new Dimension(70,Prefs.FIELD_HEIGHT));
		id.setPreferredSize(new Dimension(70,Prefs.FIELD_HEIGHT));
        idpswPanel.add(id, gbc);

        gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        idpswPanel.add(passwordLabel, gbc);

        gbc = new GridBagConstraints();
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 1;
		gbc.gridy = 1;
		password.setMinimumSize(new Dimension(70,Prefs.FIELD_HEIGHT));
		password.setMaximumSize(new Dimension(70,Prefs.FIELD_HEIGHT));
		password.setPreferredSize(new Dimension(70,Prefs.FIELD_HEIGHT));
        idpswPanel.add(password, gbc);

        gbc = new GridBagConstraints();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.ipadx = 10;
		gbc.ipady = 10;
		roleList.setVisibleRowCount(3);
		roleList.setPrototypeCellValue("XXXXXXXXXXXXXXXXXX");
		roleList.setMinimumSize(new Dimension(500,100));
		roleList.setPreferredSize(new Dimension(500,100));
		scrollPane9 = new JScrollPane(roleList);
		scrollPane9.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		scrollPane9.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        rolePanel.add(scrollPane9);
        mainPanel.add(rolePanel, gbc);

        gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 2;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
		addressPanel.setBorder(new TitledBorder("Address"));
        mainPanel.add(addressPanel, gbc);
		mainPanel.setBorder(new javax.swing.border.EtchedBorder());

		getContentPane().add(mainPanel, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.add(applyButton);
		buttonPanel.add(clearButton);
		buttonPanel.add(closeButton);
		getContentPane().add(buttonPanel, BorderLayout.SOUTH);



		JMenuItem deleteUserMenuItem = new JMenuItem("Delete");

		deleteUserMenuItem.addActionListener(
    		new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					String id = (String)userList.getSelectedValue();
					try {
						TreeMap all = wb.getSalesPersons();
						SalesPerson sp = (SalesPerson)(all.get(id));
						wb.deleteSalesPerson(sp);
						String v = (String)userList.getSelectedValue();
						DefaultListModel m = (DefaultListModel)userList.getModel();		
						m.removeElement(v);
						if (m.size() > 0) {
							userList.setSelectedIndex(m.size() - 1);
                    		id = (String)userList.getSelectedValue();
							if (id != null)
								loadSalesPerson(id);
						}
						clear();
					} catch (AngError x) {
						ErrorHandler.show(thisDialog, x);
					}
                }
            });
		userPopup.add(deleteUserMenuItem);


		clearButton.addActionListener(
           new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    clear();
                }
            }
        );

		closeButton.addActionListener(
           new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    thisDialog.hide();
                }
            }
        );

		applyButton.addActionListener(
           new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					
					int option;
					SalesPerson s=null;

					if (nameAlreadyUsed() == false) {
						option = JOptionPane.showConfirmDialog(thisDialog, wb.getLang().getString("addUserQuestion"));
                   		if (option == JOptionPane.YES_OPTION) {
							try {
								s = getSalesPerson();
								if (s == null) return;

								wb.addSalesPerson(s);
								setData();
							} catch (AngError f) {
								ErrorHandler.show(thisDialog, f);
							}
						}
					} else {
						option = JOptionPane.showConfirmDialog(thisDialog, wb.getLang().getString("continueUpdateQuestion"));
                    	if (option == JOptionPane.YES_OPTION) {
                        	try {
								s = getSalesPerson();
								if (s == null) return;

                            	wb.updateSalesPerson(s);
                				JOptionPane.showMessageDialog(
									thisDialog,
                    				"Update Successful",
                    				"Update Successful",
                    				JOptionPane.INFORMATION_MESSAGE);
                        	} catch (Exception f) {
                            	f.printStackTrace();
                        	}
                    	}
                	}
				}
            }
        );
		

 		WindowListener l = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
			}

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };
 
        addWindowListener(l);

		userList.addMouseListener(
			new MouseAdapter() {
				public void mousePressed(MouseEvent e) {
					if (e.isPopupTrigger())
						userPopup.show(userList, e.getX(), e.getY());
				}
			}
		);

        userList.addMouseListener(
            new MouseAdapter() {
                public void mouseClicked(MouseEvent e) {
					switch (e.getClickCount()) {
						case 1:
                    		String id = (String)userList.getSelectedValue();
							if (id != null)
								loadSalesPerson(id);
							break;
						default:
							break;
					}
                }
            }
		);
		
		rolePopup.add(addRoleMenuItem);
		rolePopup.add(deleteRoleMenuItem);

		roleList.addMouseListener(
			new MouseAdapter() {
				public void mousePressed(MouseEvent e) {
					if (e.isPopupTrigger())
						rolePopup.show(roleList, e.getX(), e.getY());
				}
				public void mouseReleased(MouseEvent e) {
					if (e.isPopupTrigger())
						rolePopup.show(roleList, e.getX(), e.getY());
				}
				public void mouseClicked(MouseEvent e) {
					if (e.isPopupTrigger())
						rolePopup.show(roleList, e.getX(), e.getY());
				}
			}
		);

		addRoleMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						initRoles();
						Object[] roleNames = roleNamesList.toArray();
						String roleName = (String)JOptionPane.showInputDialog(
							thisDialog,
							"Choose a role for this user.",
							"Select a role",
							JOptionPane.PLAIN_MESSAGE,
							null,
							roleNames,
							roleNames[0]);

						String id = (String)userList.getSelectedValue();
						TreeMap all = wb.getSalesPersons();
						SalesPerson sp = (SalesPerson)(all.get(id));

						UserRole role;
						for (int j=0;j<currentRoles.size();j++) {
							role = (UserRole)currentRoles.get(j);
							if (role.getName().equals(roleName)) {
								sp.addUserRole(role);
								wb.updateSalesPerson(sp);
								setRoleData(sp.getUserRoles().toArray());
								break;
							}
						}	
					} catch (AngError f) {
						ErrorHandler.show(thisDialog, f);
					}
				}
			}
		);

		deleteRoleMenuItem.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						String roleName = (String)roleList.getSelectedValue();
						String id = (String)userList.getSelectedValue();
						TreeMap all = wb.getSalesPersons();
						SalesPerson sp = (SalesPerson)(all.get(id));
						sp.removeUserRole(roleName);	
						wb.updateSalesPerson(sp);
						setRoleData(sp.getUserRoles().toArray());
					} catch (AngError f) {
						ErrorHandler.show(thisDialog, f);
					}
				}
			}
		);


		setData();
		setLang();
	}

	/**
	 *  see if a name already exists 
	 * @return true if the name already exists
	 */
	private final boolean nameAlreadyUsed() {
		TreeMap allUsers = null;
		try {
			allUsers = wb.getSalesPersons();
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}

		String screenID = id.getText();
		SalesPerson sp = (SalesPerson)allUsers.get(screenID);
		if (sp == null)
			return false;
		else
			return true;
	}

	/**
	 * load a sales person's info into this dialog
	 * @param i an index into the list of sales persons to display
	 */
	public final void loadSalesPerson(String idValue) {
		try {
			SalesPerson sp = (SalesPerson)(wb.getSalesPersons().get(idValue));
    		id.setText(sp.getID());
    		password.setText(sp.getPassword());
			setRoleData(sp.getUserRoles().toArray());
			addressPanel.setAddress(sp.getAddress());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	/**
	 *  set the dialog's data being displayed
	 */
	public final void setData() {
		try {
			TreeMap u = wb.getSalesPersons();
			Object[] keys = u.keySet().toArray();
			DefaultListModel model = new DefaultListModel();
			String id = null;
			for (int i=0;i<keys.length;i++) {
				id = (String)(keys[i]);
				model.addElement(id);
			}

			userList.setModel(model);
			if (keys.length > 0) {
				userList.setSelectedIndex(0);
				loadSalesPerson((String)keys[0]);
			}
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	/**
	 * set the user role data to display
	 * @param roles an array of UserRole objects to displsy
	 */
	public final void setRoleData(Object[] roles) {
		DefaultListModel model = new DefaultListModel();
		UserRole role = null;
		for (int i=0;i<roles.length;i++) {
			role = (UserRole)roles[i];
			model.addElement(role.getName());
		}
	
		roleList.setModel(model);
	}

	/**
	 * clear the dialog's screen 
	 */
	public final void clear() {
   		id.setText("");
   		password.setText("");
		Object[] items = { };
		setRoleData(items);
		addressPanel.clear();
	}

	/**
	 * get the SalesPerson data being shown by the dialog 
	 * @return the SalesPerson from the screen data
	 */
	public final SalesPerson getSalesPerson() {
		if (password.getText().length() == 0) {
			JOptionPane.showMessageDialog(
								thisDialog,
                    			"Password Field is blank or empty.",
                    			"Error",
                    			JOptionPane.INFORMATION_MESSAGE);
			return null;
		}

		if (id.getText().length() == 0) {
			JOptionPane.showMessageDialog(
								thisDialog,
                    			"User ID field is blank or emtpy.",
                    			"Error",
	            				JOptionPane.INFORMATION_MESSAGE);
			return null;
		}
       
		SalesPerson s = null; 
		TreeMap all = null;
		try {
			all = wb.getSalesPersons();
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
			return s;
		}

		String idVal = (String)userList.getSelectedValue();
		s =  (SalesPerson)(all.get(idVal));
		s.setID(id.getText());
   		s.setPassword(password.getText());
		Address a = addressPanel.getAddress();
		Address.copyFields(s.getAddress(), a);
		return s;
	}


	/**
	 * set the dialog's fonts
	 */
	public final void setFonts() {
		userList.setFont(MainWindow.FIELD_FONT);
		userIDLabel.setFont(MainWindow.LABEL_FONT);
		id.setFont(MainWindow.FIELD_FONT);
		passwordLabel.setFont(MainWindow.LABEL_FONT);
		password.setFont(MainWindow.FIELD_FONT);
		addressLabel.setFont(MainWindow.LABEL_FONT);
	}

	/**
	 * set the dialog's colors
	 */
	public final void setColors() {
		userIDLabel.setForeground(MainWindow.LETTERS);
		passwordLabel.setForeground(MainWindow.LETTERS);
		addressLabel.setForeground(MainWindow.LETTERS);
	}

	/**
	 * initialize the roles list
	 */
	private final void initRoles() {
		try {
			currentRoles = wb.getAllUserRoles();
			UserRole role;
			for (int i=0;i<currentRoles.size();i++) {
				role = (UserRole)currentRoles.get(i);
				roleNamesList.add(role.getName());
			}
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	/**
	 * enable or disable the dialog's fields based upon
	 * the user's security creditials
	 */
	private final void setSecurity() {
		try {
			if (wb.getLogin().userAdminWritable()) {
				addRoleMenuItem.setEnabled(true);
				deleteRoleMenuItem.setEnabled(true);
				applyButton.setEnabled(true);
			} else {
				addRoleMenuItem.setEnabled(false);
				deleteRoleMenuItem.setEnabled(false);
				applyButton.setEnabled(false);
			}
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	/**
	 * set the screen's language
	 */
	public final void setLang() {
		setTitle(wb.getLang().getString("userMaint"));
		userIDLabel.setText(wb.getLang().getString("userid"));
		passwordLabel.setText(wb.getLang().getString("password"));
		roleListLabel.setText(wb.getLang().getString("roles"));
		addRoleMenuItem.setText(wb.getLang().getString("add"));
		deleteRoleMenuItem.setText(wb.getLang().getString("delete"));
		addressLabel.setText(wb.getLang().getString("address"));
		applyButton.setText(wb.getLang().getString("apply"));
		clearButton.setText(wb.getLang().getString("clear"));
		closeButton.setText(wb.getLang().getString("close"));
		userPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("currUsers"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
		rolePanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("roles"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
		addressPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("address"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		);
	}
}
