package sellwin.server;

import java.io.*;
import java.net.*;
import java.util.*;

import sellwin.domain.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * simple chat server, started from the command line
 * waits for client request, processes them
 */
public class ChatServer {

	/** global list of online chat users */
	private static TreeMap onlineUsers = new TreeMap();

    public static final int DEFAULT_PORT = 7900;

    public static void main(String[] args) {
		int port = DEFAULT_PORT;
		ServerSocket serverSocket = null;
		Socket socket = null;

		System.out.println("ChatServer v1.0 starting");

		try {
	    	if(args.length > 0)
	        	port = Integer.parseInt(args[0]);
		} catch(NumberFormatException nfe) {
	    	System.err.println("Usage: java ChatServer [port]");
	    	System.err.println("Where options include:");
	    	System.err.println("\tport the port on which to listen.");
	    	System.exit(0);
		}

		try {
	    	serverSocket = new ServerSocket(port);
			System.out.println("waiting for chat clients");

	        ChatReaper reaper = new ChatReaper(onlineUsers);
			reaper.start();

	    	while(true) {
	        	socket = serverSocket.accept();
	        	ChatHandler handler = new ChatHandler(socket, onlineUsers);
	        	handler.start();
	    	}

		} catch(IOException ioe) {
	    	ioe.printStackTrace();
		} finally {
	    	try {
	        	serverSocket.close();
	    	} catch(IOException ioe) {
				ioe.printStackTrace();
	    	}
		}
    }
}
