package sellwin.server;

import java.sql.*;
import java.rmi.*;
import java.util.*;
import javax.ejb.*;
import javax.sql.*;
import javax.naming.*;

import sellwin.domain.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * this class is a stateful session bean that delegates client
 * calls to the BizServices class which actually implements the
 * business services we are providing to the outside world (clients)
 * when they are configured to communicate via EJB technology
 */
public class SellwinSessionBean extends BizServices implements SessionBean {

	private SessionContext ctx;
	private Context environment;

	private DataSource ds;

	//some state

	public SellwinSessionBean() {
		super();
	}

	/**
	 * set the session context
	 *
	 * @param ctx SessionContext for session
	 */
	public void setSessionContext(SessionContext ctx) {
		this.ctx = ctx;
	}

	/**
	 * this method is required by the EJB SessionBean interface
	 * and does nothing special for this implementation
	 */
	public void ejbActivate() {
		System.out.println("ejbActivate called");
	}

	/**
	 * this method is required by the EJB SessionBean interface
	 * and does nothing special for this implementation
	 */
	public void ejbPassivate() {
		System.out.println("ejbPassivate called");
	}

	/**
	 * this method is required by the EJB SessionBean interface
	 * and does nothing special for this implementation
	 */
	public void ejbRemove() {
		System.out.println("ejbRemove called");
	}

	/**
	 * this method corresponds to the create method in the 
	 * SellwinSessionHome interface.  When the client calls
	 * SellwinSessionHome.create(), the container allocates an
	 * instance of the session bean and calls this method, ejbCreate()
	 *
	 * @exception javax.ejb.CreateException 
	 * 		if there is a problem creating the bean
	 */
	public void ejbCreate() throws CreateException {

		try {
			InitialContext ic = new InitialContext();
			System.out.println("got the initial context");
			System.out.println("about to get datasource");
			//weblogic uses the next JNDI name for the lookup
			//ds = (DataSource)ic.lookup("sellwinPool");
			//jboss uses the next JNDI name for the lookup
			//ds = (DataSource)ic.lookup("java:/OracleDB");
			ds = (DataSource)ic.lookup("java:/SellwinDS");
			System.out.println("got handle to jdbc data source");
		} catch (NamingException e) {
			e.printStackTrace();
			throw new CreateException("could not find initial context");
		}
	}

	/**
	 * get the weblogic initial context used for
	 * jndi lookups (i.e. jdbc datasource)
	 * @return the InitialContext
	 */
	public javax.naming.InitialContext getContext() 
		throws javax.naming.NamingException {
	
		Hashtable ht = new Hashtable();
		ht.put(Context.INITIAL_CONTEXT_FACTORY,
			"weblogic.jndi.WLInitialContextFactor");
		ht.put(Context.PROVIDER_URL,
			"t3://localhost:7001");
		javax.naming.InitialContext ctx = new InitialContext(ht);

		return ctx;

	}

	/**
	 * get the datasource used to get jdbc connections
	 * by doing a jndi lookup via the EJB container's 
	 * context
	 * @param ctx the InitialContext to do the lookup with
	 * @return the DataSource found
	 */
	public javax.sql.DataSource getDataSource(InitialContext ctx) 
		throws javax.naming.NamingException {

		javax.sql.DataSource ds = (javax.sql.DataSource)
			ctx.lookup("sellwinPool");
		return ds;
	}

	/**
	 * @see sellwin.server.BizServices updateLead method
	 */
	public void updateLead(long campPK, Lead l)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			leadDB.setConnection(con);
			super.updateLead(campPK, l);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getOpportunityIndex method
	 */
	public ArrayList getOpportunityIndex(SalesPerson u)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			return super.getOpportunityIndex(u);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getProductMatrix method
	 */
	public ArrayList getProductMatrix()
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			productDB.setConnection(con);
			return super.getProductMatrix();
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getProductsForLine method
	 */
	public ArrayList getProductsForLine(String group, String line)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			productDB.setConnection(con);
			return super.getProductsForLine(group, line);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getProduct method
	 */
	public Product getProduct(String group, String line, String name)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			productDB.setConnection(con);
			return super.getProduct(group, line, name);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addForecast method
	 */
	public long addForecast(long opportunityPK, Forecast forecast)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			forecastDB.setConnection(con);
			return super.addForecast(opportunityPK, forecast);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateForecast method
	 */
	public void updateForecast(long oppPK, Forecast forecast)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			forecastDB.setConnection(con);
			super.updateForecast(oppPK, forecast);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteForecast method
	 */
	public void deleteForecast(long oppPK, long forecastPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			forecastDB.setConnection(con);
			super.deleteForecast(oppPK, forecastPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addOrder method
	 */
	public long addOrder(long oppPK, Order order)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			orderDB.setConnection(con);
			return super.addOrder(oppPK, order);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateOrder method
	 */
	public void updateOrder(long oppPK, Order order)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			orderDB.setConnection(con);
			super.updateOrder(oppPK, order);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addQuote method
	 */
	public long addQuote(long oppPK, Quote quote)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			quoteDB.setConnection(con);
			return super.addQuote(oppPK, quote);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateQuote method
	 */
	public void updateQuote(long oppPK, Quote quote)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			quoteDB.setConnection(con);
			super.updateQuote(oppPK, quote);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteQuote method
	 */
	public void deleteQuote(long oppPK, long quotePK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			quoteDB.setConnection(con);
			super.deleteQuote(oppPK, quotePK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addQuoteLine method
	 */
	public long addQuoteLine(long oppPK, long quotePK, QuoteLine quoteLine)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			quoteLineDB.setConnection(con);
			return super.addQuoteLine(oppPK, quotePK, quoteLine);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteQuoteLine method
	 */
	public void deleteQuoteLine(long oppPK, long quotePK, long quoteLinePK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			quoteLineDB.setConnection(con);
			super.deleteQuoteLine(oppPK, quotePK, quoteLinePK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getAlarms method
	 */
	public ArrayList getAlarms(long salesPersonPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			activityDB.setConnection(con);
			return super.getAlarms(salesPersonPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addActivity method
	 */
	public long addActivity(long opportunityPK, Activity activity)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			activityDB.setConnection(con);
			return super.addActivity(opportunityPK, activity);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateActivity method
	 */
	public void updateActivity(long opportunityPK, Activity activity)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			activityDB.setConnection(con);
			super.updateActivity(opportunityPK, activity);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteActivity method
	 */
	public void deleteActivity(long opportunityPK, long activityPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			activityDB.setConnection(con);
			super.deleteActivity(opportunityPK, activityPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getAllUserRoles method
	 */
	public ArrayList getAllUserRoles(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userRoleDB.setConnection(con);
			return super.getAllUserRoles(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addUserRole method
	 */
	public void addUserRole(UserRole userRole)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userRoleDB.setConnection(con);
			super.addUserRole(userRole);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteUserRole method
	 */
	public void deleteUserRole(long pk)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userRoleDB.setConnection(con);
			super.deleteUserRole(pk);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateUserRole method
	 */
	public void updateUserRole(UserRole userRole)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userRoleDB.setConnection(con);
			super.updateUserRole(userRole);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getUserRole method
	 */
	public UserRole getUserRole(String userRoleName)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userRoleDB.setConnection(con);
			return super.getUserRole(userRoleName);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices logon method
	 */
	public Login logon(String id, String psw)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			System.out.println("logon called id=" + id + " psw=" + psw);
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.logon(id, psw);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				if (con != null) con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteCustomer method
	 */
	public void deleteCustomer(String customerName)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			super.deleteCustomer(customerName);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteCustomer method
	 */
	public void updateCustomer(Customer customer)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			super.updateCustomer(customer);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addCustomer method
	 */
	public long addCustomer(Customer customer)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			return super.addCustomer(customer);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCustomer method
	 */
	public Customer getCustomer(String customerName)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			return super.getCustomer(customerName);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getAllCustomerNames method
	 */
	public Object[] getAllCustomerNames()
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			return super.getAllCustomerNames();
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCustomers method
	 */
	public ArrayList getCustomers(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			customerDB.setConnection(con);
			return super.getCustomers(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getStateTax method
	 */
	public ArrayList getStateTax(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			stateTaxDB.setConnection(con);
			return super.getStateTax(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addProduct method
	 */
	public void addProduct(Product product)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			productDB.setConnection(con);
			super.addProduct(product);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getProducts method
	 */
	public ArrayList getProducts(java.util.Date afterDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			productDB.setConnection(con);
			return super.getProducts(afterDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getOpportunityNames method
	 */
	public ArrayList getOpportunityNames(SalesPerson salesPerson)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			return super.getOpportunityNames(salesPerson);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getOpportunities method
	 */
	public ArrayList getOpportunities(SalesPerson salesPerson, java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			return super.getOpportunities(salesPerson, lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getOpportunity method
	 */
	public Opportunity getOpportunity(long oppPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			return super.getOpportunity(oppPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteOpportunity method
	 */
	public void deleteOpportunity(long oppPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			super.deleteOpportunity(oppPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addOpportunity method
	 */
	public long addOpportunity(Opportunity opp)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			return super.addOpportunity(opp);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateOpportunity method
	 */
	public void updateOpportunity(Opportunity opp)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			oppDB.setConnection(con);
			super.updateOpportunity(opp);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteContact method
	 */
	public void deleteContact(long oppPK, long contactPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			contactDB.setConnection(con);
			super.deleteContact(oppPK, contactPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateContact method
	 */
	public void updateContact(long oppPK, Contact contact)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			contactDB.setConnection(con);
			super.updateContact(oppPK, contact);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addContact method
	 */
	public long addContact(long oppPK, Contact contact)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			contactDB.setConnection(con);
			return super.addContact(oppPK, contact);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getSalesPersons method
	 */
	public Object[] getSalesPersons(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.getSalesPersons(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getSalesPerson method
	 */
	public SalesPerson getSalesPerson(long pk)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.getSalesPerson(pk);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices updateSalesPerson method
	 */
	public void updateSalesPerson(SalesPerson salesPerson)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			super.updateSalesPerson(salesPerson);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteSalesPerson method
	 */
	public void deleteSalesPerson(SalesPerson person)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			super.deleteSalesPerson(person);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addSalesPerson method
	 */
	public long addSalesPerson(SalesPerson salesPerson)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.addSalesPerson(salesPerson);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getSalesPersonIDs method
	 */
	public ArrayList getSalesPersonIDs()
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.getSalesPersonIDs();
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getSalesPersonNames method
	 */
	public ArrayList getSalesPersonNames()
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			salesPersonDB.setConnection(con);
			return super.getSalesPersonNames();
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addUserToGroup method
	 */
	public void addUserToGroup(long userPK, UserGroup group)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			ugMemberDB.setConnection(con);
			super.addUserToGroup(userPK, group);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getUsersInGroup method
	 */
	public Object[] getUsersInGroup(String groupName)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userGroupDB.setConnection(con);
			return super.getUsersInGroup(groupName);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getUserGroup method
	 */
	public UserGroup getUserGroup(long pk)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userGroupDB.setConnection(con);
			return super.getUserGroup(pk);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getUserGroups method
	 */
	public Object[] getUserGroups(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userGroupDB.setConnection(con);
			return super.getUserGroups(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addUserGroup method
	 */
	public void addUserGroup(UserGroup group)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userGroupDB.setConnection(con);
			super.addUserGroup(group);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteUserGroup method
	 */
	public void deleteUserGroup(String groupName)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			userGroupDB.setConnection(con);
			super.deleteUserGroup(groupName);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteUserInGroup method
	 */
	public void deleteUserInGroup(UserGroup group, long userPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			ugMemberDB.setConnection(con);
			super.deleteUserInGroup(group, userPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getGroupsForUser method
	 */
	public ArrayList getGroupsForUser(long userPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			ugMemberDB.setConnection(con);
			return super.getGroupsForUser(userPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCampaigns method
	 */
	public ArrayList getCampaigns(java.util.Date lastSyncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			campaignDB.setConnection(con);
			return super.getCampaigns(lastSyncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCampaignLeads method
	 */
	public ArrayList getCampaignLeads(java.util.Date syncDate)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			leadDB.setConnection(con);
			return super.getCampaignLeads(syncDate);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCampaignLeads method
	 */
	public ArrayList getCampaignLeads(long campaignPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			leadDB.setConnection(con);
			return super.getCampaignLeads(campaignPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices uploadDeletes method
	 */
	public void uploadDeletes(ArrayList deletes)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			activityDB.setConnection(con);
			forecastDB.setConnection(con);
			quoteDB.setConnection(con);
			quoteLineDB.setConnection(con);
			contactDB.setConnection(con);
			oppDB.setConnection(con);
			super.uploadDeletes(deletes);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices addCustomerInventory method
	 */
	public long addCustomerInventory(CustomerInventory ci)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			custInventoryDB.setConnection(con);
			return super.addCustomerInventory(ci);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices deleteCustomerInventory method
	 */
	public void deleteCustomerInventory(CustomerInventory ci)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			custInventoryDB.setConnection(con);
			super.deleteCustomerInventory(ci);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

	/**
	 * @see sellwin.server.BizServices getCustomerInventory method
	 */
	public ArrayList getCustomerInventory(long customerPK)
		throws RemoteException, AngError {

		Connection con=null;

		try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			custInventoryDB.setConnection(con);
			return super.getCustomerInventory(customerPK);
		} catch (SQLException s) {
			throw new AngError(s.getMessage());
		} catch (AngError a) {
			throw a;
		} catch (RemoteException r) {
			throw r;
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
	}

  	/**
     * get all the UserGroupMembers
     * @param lastSyncDate a user's last sync date or null, used to
     * limit the query
     * @return an ArrayList of UserGroupMember objects
     */
    public final ArrayList getGroupMembers(java.util.Date lastSyncDate)
        throws RemoteException, AngError {

		Connection con=null;
        
        try {
			con = ds.getConnection();
			con.setAutoCommit(false);
			ugMemberDB.setConnection(con);
			return super.getGroupMembers(lastSyncDate);
        } catch (SQLException e) {
            e.printStackTrace();
            throw new AngError(e.getMessage());
		} finally {
			try { 
				con.close(); 
			} catch (SQLException x) {
				x.printStackTrace(); 
			}
		}
    }

}
