#!/bin/sh
# $Id: startSellwin.sh,v 1.1.1.1 2002/07/31 21:31:13 jeffery3_1998 Exp $
#
# This script can be used to start WebLogic Server for the purpose
# of running the SellWin application's server components. This script ensures 
# that the server is started
# using the config.xml file found in this directory and that the CLASSPATH
# is set appropriately. This script contains the following variables:
#
# WL_HOME        - The root directory of your WebLogic Server
#                  installation
# JAVA_HOME      - Determines the version of Java used to start
#                  WebLogic Server. This variable must point to the
#                  root directory of a JDK installation and will be set
#                  for you by the WebLogic Server installer.
#                  See the WebLogic platform support
#                  page (http://e-docs.bea.com/wls/platforms/index.html)
#                  for an up-to-date list of supported JVMs on your platform.
# JAVA_OPTIONS   - Java command-line options for running the server.
#
# Set user-defined variables.
JAVA_HOME=/usr/java/jdk1.3.1_02
WL_HOME=/apps/bea/wlserver6.1

JAVACMD=java
JAVA_OPTIONS="-ms64m -mx64m"

# Check that script is being run from the appropriate directory
if [ ! -f config.xml ]; then
  echo "startSellwin.sh: must be run from the config/sellwin directory." 1>&2

# Check for classes
elif [ ! -f $WL_HOME/lib/weblogic.jar ]; then
  echo "The weblogic.jar file was not found in directory $WL_HOME/lib." 1>&2

# Check for JDK
elif [ ! -f $JAVA_HOME/bin/javac ]; then
  echo "The JDK wasn't found in directory $JAVA_HOME." 1>&2

else

cd ../..

# Grab some file descriptors.
if [ "`uname -s`" != "OSF1" ]; then
  maxfiles=`ulimit -H -n`
else
  maxfiles=`ulimit -n`
fi
if [ !$? -a "$maxfiles" != 1024 ]; then
  if [ "$maxfiles" = "unlimited" ]; then
    maxfiles=1025
  fi
  if [ "$maxfiles" -lt 1024 ]; then
    ulimit -n $maxfiles
  else
    ulimit -n 1024
  fi
fi

# Figure out how to use our shared libraries
case `uname -s` in
LINUX|Linux)
  arch=`uname -m`
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/linux/$arch:$WL_HOME/lib/linux/$arch/oci816_8
  fi
  PATH=$WL_HOME/lib/linux:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
;;
SunOS)
  if [ -n "$LD_LIBRARY_PATH" ]; then
    LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  else
    LD_LIBRARY_PATH=$WL_HOME/lib/solaris:$WL_HOME/lib/solaris/oci816_8
  fi
  PATH=$WL_HOME/lib/solaris:$PATH
  export LD_LIBRARY_PATH PATH
  echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  JAVA_OPTIONS="-hotspot $JAVA_OPTIONS"
;;
*)
  echo "$0: Don't know how to set the shared library path for `uname -s`.  "
esac

CLASSPATH=$WL_HOME:$WL_HOME/lib/weblogic_sp.jar
CLASSPATH=$CLASSPATH:$WL_HOME/lib/weblogic.jar
CLASSPATH=$CLASSPATH:$ORACLE_HOME/jdbc/lib/classes111.zip
CLASSPATH=$CLASSPATH:$WL_HOME/config/sellwin/serverclasses

PATH=$WL_HOME/bin:$JAVA_HOME/jre/bin:$JAVA_HOME/bin:$PATH

echo
echo "***************************************************"
echo "*  To start WebLogic Server, use the password     *"
echo "*  assigned to the system user.  The system       *"
echo "*  username and password must also be used to     *"
echo "*  access the WebLogic Server console from a web  *"
echo "*  browser.                                       *"
echo "***************************************************"

# Set WLS_PW equal to your system password for no password prompt server startup.
WLS_PW=

$JAVACMD $JAVA_OPTIONS -classpath $CLASSPATH -Dweblogic.Domain=sellwin \
-Dweblogic.Name=sellwinServer \
-Dweblogic.management.password=$WLS_PW \
-Dbea.home=/apps/bea \
-Djava.security.policy==$WL_HOME/lib/weblogic.policy weblogic.Server

cd config/sellwin

fi
