package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class implements the DBInterface for
 * the Attendee class objects which are stored
 * in the attendee database table.
 */
public class AttendeeDB extends DBType implements DBInterface {
	private Connection con;

	private final static String selectQuery = 
			"SELECT " +
				"activity_pk, person_pk, " +
    			"modified_by, modified_date " +
			"FROM attendee" +
			"WHERE pk=";

	private final static String insertQuery = 
			"INSERT INTO attendee VALUES ( ";

	private final static String deleteQuery = 
			"DELETE FROM attendee WHERE pk =";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 *
	 */
	public AttendeeDB() {
	}

	/** 
	 * construct using a dbtype
	 * @param dbType the database type
	 */
	public AttendeeDB(int dbType) {
		DB_TYPE=dbType;
	}

	/**
	 * a constructor that accepts an existing Connection
	 * to use for future operations
	 *
	 * @param con the Connection to use
	 */
	public AttendeeDB(Connection con) {
		this.con = con;
	}

	/**
	 * get the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single attendee row using the passed
	 * primary key
	 * 
	 * @param pk the primary key we are searching with
	 * @return the Attendee(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		Attendee attendee = new Attendee();
		attendee.setPK(((Long)pk).longValue());
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectQuery + attendee.getPK();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;
			while (rs.next()) {
				i=1;
				attendee.setActivityPK(rs.getLong(i)); i++;
				attendee.setPersonPK(rs.getLong(i)); i++;
				AddressDB pdb = new AddressDB(DB_TYPE);
				pdb.setConnection(getConnection());
				Address a = (Address)(pdb.selectRow(new Long(attendee.getPersonPK())));
				attendee.setPerson(a);
				attendee.setModifiedBy(rs.getString(i)); i++;
				attendee.setModifiedDate(rs.getDate(i)); 
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return attendee;
	}


	/**
	 * not necessary at the moment
	 *
	 * @param name description
	 * @exception java.sql.SQLException 
	 */
	public void updateRow(Object obj) 
		throws SQLException {

	}

	/**
	 * insert a new attendee row using the passed
	 * Attendee object as the column values.
	 * 
	 * @param obj the object we are inserting
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public long insertRow(Object obj, boolean load) 
		throws SQLException {

		Attendee attendee = (Attendee)obj;

		if (!load)
			attendee.setPK(DBUtils.generatePK());

		Statement stmt = null;
		StringBuffer query = new StringBuffer(insertQuery);

		try {
			stmt = con.createStatement();

			query.append(attendee.getPK()).append(",");
			query.append(attendee.getActivityPK()).append(",");
			query.append(attendee.getPerson().getPK()).append(",");
			query.append(JDBC.quoteMore(attendee.getModifiedBy()));
			query.append(JDBC.quote(DateUtils.format(DB_TYPE, attendee.getModifiedDate())));
			query.append(")");

			if (Prefs.DEBUG) LogWrite.write(query.toString());
			int rc = stmt.executeUpdate(query.toString());
		} catch (SQLException e) {
			throw e;
		} finally {
			try { if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}

		return attendee.getPK();
	}

	/**
	 * delete a single attendee row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();
		String query = deleteQuery + pkValue;
	
		Statement stmt = null;
		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try { if (stmt != null) stmt.close();
			} catch (SQLException x) { }		
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table attendee";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
