package sellwin.db;

import java.sql.*;
import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This interface is implemented by all the database classes.  It
 * simply serves to enforce some of the more basic SQL routines that
 * are to be supplied by the database layer classes.
 */
public interface DBInterface {

	/**
	 * get the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection();

	/**
	 * set the Connection to use when inserting, deleting, etc.
	 *
	 * @param con the Connection to use
	 */
	public void setConnection(Connection con)
		throws SQLException;

	/**
	 * perform a SQL UPDATE on a row
	 *
	 * @param obj use the contents to update table columns
	 */
	public void updateRow(Object obj)
		throws SQLException;

	/**
	 * perform a SQL INSERT 
	 *
	 * @param obj use the contents to insert a new row
	 * @param load true if the row is to be loaded, false if
	 * the row is to be added for the first time
	 */
	public long insertRow(Object obj, boolean load)
		throws SQLException;

	/**
	 * perform a SQL DELETE
	 *
	 * @param obj use the contents to delete a row
	 */
	public void deleteRow(Object obj)
		throws SQLException;

	/**
	 * perform a SQL SELECT
	 *
	 * @param obj use the contents to select a row
	 * @return the fetched row
	 */
	public Object selectRow(Object obj)
		throws SQLException;

}
