package sellwin.db;

import sellwin.domain.*;
import sellwin.utils.*;

import java.sql.*;
import java.util.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class implements the DBInterface for
 * the DeleteInfo class objects which are stored
 * in the delete_info database table.
 */
public class DeleteInfoDB extends DBType implements DBInterface {

	private Connection con;

	private final static String selectQuery = 
			"SELECT " +
				"class_name " +
			"FROM delete_info " +
			"WHERE pk=";

	private final static String selectAllQuery =
			"SELECT * FROM delete_info ORDER BY pk";

	private final static String insertQuery = 
			"INSERT INTO delete_info VALUES ( ";

	private final static String deleteQuery = 
			"DELETE FROM delete_info WHERE pk =";

	private final static String deleteAllQuery = 
			"DELETE FROM delete_info";

	/**
	 * a do-nothing constructor but necessary to
	 * do the operations offered by this class
	 */
	public DeleteInfoDB() {
	}

	/**
 	 * construct using a db type
	 * @param dbType the database type 
	 */
	public DeleteInfoDB(int dbType) {
		DB_TYPE=dbType;
	}

	/**
	 * a constructor that accepts an existing Connection
	 * to use for future operations
	 *
	 * @param con the Connection to use
	 */
	public DeleteInfoDB(Connection con) {
		this.con = con;
	}

	/**
	 * get the Connection in use
	 *
	 * @return the Connection in use
	 */
	public Connection getConnection() {
		return this.con;
	}

	/**
	 * set the Connection to use 
	 *
	 * @param con the Connection to use for any future IO's
	 */
	public void setConnection(Connection con) 
		throws SQLException {

		this.con = con;
	}

	/**
	 * select a single delete_info row using the passed
	 * primary key
	 * 
	 * @param pk the primary key we are searching with
	 * @return the DeleteInfo(s) that were selected
	 * @exception java.sql.SQLException 
	 */
	public final Object selectRow(Object pk) 
		throws SQLException {

		DeleteInfo deleteInfo=null;
		Statement stmt = null;
		ResultSet rs = null;
		Long l = (Long)pk;

		String query = selectQuery + l.longValue();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			int i;
			while (rs.next()) {
				deleteInfo = new DeleteInfo(l.longValue(), rs.getString(1));
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return deleteInfo;
	}


	/**
	 * not implemented, not needed
	 *
	 * @param obj the object we want to update with
	 * @exception java.sql.SQLException 
	 */
	public void updateRow(Object obj) 
		throws SQLException {

		DeleteInfo deleteInfo = (DeleteInfo)obj;
	}

	/**
	 * insert a new deleteInfo row using the passed
	 * DeleteInfo object as the column values.
	 * 
	 * @param obj the object we are inserting
	 * @param load not used by this routine
	 * @return the newly assigned primary key of the new row
	 * @exception java.sql.SQLException 
	 */
	public long insertRow(Object obj, boolean load) 
		throws SQLException {

		DeleteInfo deleteInfo = (DeleteInfo)obj;

		Statement stmt = null;
		StringBuffer query = new StringBuffer(insertQuery);

		try {
			stmt = con.createStatement();

			query.append(deleteInfo.pk).append(",");
			query.append(JDBC.quoteMore(deleteInfo.className));
			query.append(")");

			if (Prefs.DEBUG) LogWrite.write(query.toString());
			int rc = stmt.executeUpdate(query.toString());
		} catch (SQLException e) {
			throw e;
		} finally {
			try { if (stmt != null) stmt.close();
			} catch (SQLException x) { }
		}

		return deleteInfo.pk;
	}

	/**
	 * delete a single deleteInfo row using the passed
	 * primary key value
	 *
	 * @param ojb primary key stored in a Long
	 * @exception java.sql.SQLException 
	 */
	public final void deleteRow(Object obj) 
		throws SQLException {

		long pkValue = ((Long)obj).longValue();
		String query = deleteQuery + pkValue;
	
		Statement stmt = null;
		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try { if (stmt != null) stmt.close();
			} catch (SQLException x) { }		
		}
	}

	/**
	 * select all delete_info rows 
	 * 
	 * @return an ArrayList of DeleteInfo objects
	 * @exception java.sql.SQLException 
	 */
	public final ArrayList selectAllRows() 
		throws SQLException {

		DeleteInfo deleteInfo;
		Statement stmt = null;
		ResultSet rs = null;
		String query = selectAllQuery;
		ArrayList list = new ArrayList();

		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			rs = stmt.executeQuery(query);

			while (rs.next()) {
				deleteInfo = new DeleteInfo(rs.getLong(1), rs.getString(2));
				list.add(deleteInfo);
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null) rs.close();
			} catch (SQLException x) { throw x; }
			try {
				if (stmt != null) stmt.close();
			} catch (SQLException x) { throw x; }
		}

		return list;
	}

	/**
	 * delete all deleteInfo rows 
	 *
	 * @exception java.sql.SQLException 
	 */
	public final void deleteAllRows() 
		throws SQLException {

		String query = deleteAllQuery;
	
		Statement stmt = null;
		try {
			stmt = con.createStatement();
			if (Prefs.DEBUG) LogWrite.write(query);
			stmt.executeUpdate(query);
		} catch (SQLException e) {
			throw e;
		} finally {
			try { if (stmt != null) stmt.close();
			} catch (SQLException x) { }		
		}
	}
    /**
     * truncate the whole table
     *
     * @exception java.sql.SQLException
     */
    public final void truncate()
        throws SQLException {

        String query = "truncate table delete_info";
   
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (Prefs.DEBUG) LogWrite.write(query);
            stmt.executeUpdate(query);
        } catch (SQLException e) {
            throw e;
        } finally {
            try { if (stmt != null) stmt.close();
            } catch (SQLException x) { }
        }
    }

}
