package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class represents an Activity in the system.  Activities
 * are 'owned' by an Opportunity.  An activity can act as an alarm
 * to the user.  This class holds column values found in the 'activity'
 * database table.
 */
public class Activity implements Serializable {
	private long pk;
	private long oppPK;
	private String subject;
	private String type;
	private String place;
	private String message;
	private Date startDate;
	private Integer duration; //units are in minutes
	private boolean groupAlarm=false; //group alarm requested
	private boolean groupAlarmAck=false; //group alarm delivered
	private Boolean alarm=new Boolean(false); //owner alarm requested
	private boolean alarmAck=false; //owner alarm delivered
	private ArrayList attendees = new ArrayList(); //String objects
	private String modifiedBy;
	private Date modifiedDate;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;

	public final static String[] TYPES = {
		"Meeting", "Callback", "Conf Call", "Birthday", "Appt", "Delivery"
	};

	public Activity() {
	}

	public Activity(String n) {
		pk = 0L;
		oppPK = 0L;
		subject  = n;
		type = TYPES[0];
		duration = new Integer(15);
		startDate = new Date();
		modifiedDate = new Date();
	}

	public final long getPK() { return pk; }
	public final void setPK(long pk) { this.pk = pk; }

	public final long getOppPK() { return oppPK; }
	public final void setOppPK(long pk) { oppPK = pk; }

	public final void setSubject(String n) { subject = n; }
	public final String getSubject() { return subject; }

	public final void setType(String t) { type = t; }
	public final String getType() { return type; }

	public final String getPlace() { return place; }
	public final void setPlace(String s) { place = s; }

	public final String getMessage() { return message; }
	public final void setMessage(String s) { message = s; }

	public final void setStartDate(Date d) { startDate=d; }
	public final Date getStartDate() { return startDate; }

	public final void setDuration(Integer d) { duration=d; }
	public final Integer getDuration() { return duration; }

	public final boolean getGroupAlarm() { return groupAlarm; }
	public final void setGroupAlarm(boolean t) { groupAlarm = t; }

	public final boolean getGroupAlarmAck() { return groupAlarmAck; }
	public final void setGroupAlarmAck(boolean b) { groupAlarmAck = b; }

	public final Boolean getAlarm() { return alarm; }
	public final void setAlarm(Boolean t) { alarm= t; }

	public final boolean getAlarmAck() { return alarmAck; }
	public final void setAlarmAck(boolean t) { alarmAck = t; }

	public final ArrayList getAttendees() { return attendees; }

	public final void addAttendee(String attendee) {
		attendees.add(attendee);
	}

	public final String getModifiedBy() { return modifiedBy; }
	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final void setModifiedDate(Date d) { modifiedDate=d; }

	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }

	public final boolean getUpdatedLocally() { return updatedLocally; }
	public final boolean getAddedLocally() { return addedLocally; }

	public final void print() {
		System.out.println("Activity");
		System.out.println("pk="+getPK());
		System.out.println("subject="+getSubject());
		System.out.println("place="+getPlace());
		System.out.println("message="+getMessage());
		System.out.println("type="+getType());
		System.out.println("start date="+getStartDate());
		System.out.println("alarm ="+getAlarm());
		System.out.println("alarm ack="+getAlarmAck());
		System.out.println("group alarm="+getGroupAlarm());
		System.out.println("group alarm ack="+getGroupAlarmAck());
		System.out.println("created by ="+getModifiedBy());
		System.out.println("created date ="+getModifiedDate());
	}

	public final Activity copy() {
		String copySubject = new String(subject);
		Activity copy = new Activity(copySubject);
		copy.pk =  pk;
		if (type != null)
			copy.type = new String(type);
		if (place != null)
			copy.place = new String(place);
		if (message != null)
			copy.message = new String(message);
		if (startDate != null)
			copy.startDate = new Date(startDate.getTime());
		copy.duration = duration;
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		if (modifiedDate != null)
			copy.modifiedDate = new Date(modifiedDate.getTime());

		copy.alarmAck = alarmAck;
		copy.alarm= alarm;
		copy.groupAlarm = groupAlarm;
		copy.groupAlarmAck = groupAlarmAck;
	
		String attendee, attendeeCopy;	
		for (int i=0;i<attendees.size();i++) {
			attendee = (String)attendees.get(i);
			attendeeCopy = new String(attendee);
			copy.addAttendee(attendeeCopy);
		}
		return copy;
	}
}
