package sellwin.domain;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


import java.io.*;
import java.util.*;

/**
 * the chat message structure that gets send and received
 * by chat clients and server
 */
public class ChatPacket implements Serializable {
	// 0 - normal send 
	// 1 - return all online users
	public static final int SEND_MSG = 0;
	public static final int QUERY_USERS = 1;
	public static final int LOGON = 2;
	public int action; 

	//only filled when the action is '0'
	public ArrayList sendToList;

	//only filled when the action is '1'
	public ArrayList onlineUsers;

	public String message;
	public String sender;

	public ChatPacket() {
	}

	public void print() {
		if (action == 0)  {
			System.out.println("message: " + action + ":" + message + " from " + sender);
			System.out.println("list of recipients...");
			for (int j=0;j<sendToList.size();j++) {
				System.out.println("user:" + (String)sendToList.get(j));
			}
		} else {
			System.out.println("list of online users....");
			for (int i=0;i<onlineUsers.size();i++) {
				System.out.println("user:" + (String)onlineUsers.get(i));
			}
		}
	}

	public void setAction(int action) {
		this.action = action;
	}
	public int getAction() { return action; }

	public void setToList(ArrayList toList) {
		this.sendToList = toList;
	}
	public ArrayList getToList() { return sendToList; }


	public void setOnlineUsers(ArrayList users) {
		this.onlineUsers = users;
	}
	public ArrayList getOnlineUsers() { return onlineUsers; }

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage() { return message; }

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getSender() { return sender; }
}
