package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a sales contact which is associated
 * to some opportunity.  This class is used to hold database
 * column values found in the 'contact' database table. 
 */
public class Contact implements  Serializable {
	private long pk;
	private long oppPK;
	private long addressPK;
	private Address address;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;

	
	public Contact() {
		modifiedDate = new Date();
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final long getPK() { return pk; }

	public final void setOppKey(long pk) { this.oppPK = pk; }
	public final long getOppKey() { return oppPK; }

	public final void setAddressKey(long pk) { this.addressPK = pk; }
	public final long getAddressKey() { return addressPK; }

	public final void setAddress(Address a) { address = a; }
	public final Address getAddress() { return address; }

	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setModifiedDate(Date s) { modifiedDate = s; }
	public final Date getModifiedDate() { return modifiedDate; }

	public final void setUpdatedLocally(boolean b) { 
		updatedLocally=b;
	}
	public final void setAddedLocally(boolean b) {
		addedLocally=b;
	}
	public final boolean getAddedLocally() { return addedLocally; }
	public final boolean getUpdatedLocally() { return updatedLocally; }

	public final Contact copy() {
		Contact copy = new Contact();
		copy.pk = pk;
		copy.oppPK = oppPK;
		copy.addressPK = addressPK;
		copy.modifiedDate = new Date(modifiedDate.getTime());
		copy.modifiedBy = new String(modifiedBy);

		return copy;

	}

	public final void print() {
		System.out.println("<<Contact>>");
		System.out.println("pk=["+getPK()+"]");
		System.out.println("opppk=["+getOppKey()+"]");
		System.out.println("addresspk=["+getAddressKey()+"]");
		System.out.println("ModifiedBy="+ getModifiedBy());
		System.out.println("ModifiedDate="+ getModifiedDate());
	}

	public static void copyFields(Contact to, Contact from) {
		Address.copyFields(to.getAddress(), from.getAddress());
	}
}
