package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a sales forecast which is associated
 * to some opportunity.  This class is used to hold database
 * column values found in the 'forecast' database table. 
 */
public class Forecast implements  Serializable {
	private long pk;
	private long oppPK;
	private String name;
	private Date closeDate;
	private Boolean submitted;
	private Date submittedDate;
	private String submittedBy;
	private Integer revenue; 
	private Integer profit; 
	private Double margin;
	private String scenario;
	private Integer amountJan;
	private Integer amountFeb;
	private Integer amountMar;
	private Integer Q1;
	private Integer amountApr;
	private Integer amountMay;
	private Integer amountJun;
	private Integer Q2;
	private Integer amountJul;
	private Integer amountAug;
	private Integer amountSep;
	private Integer Q3;
	private Integer amountOct;
	private Integer amountNov;
	private Integer amountDec;
	private Integer Q4;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean addedLocally=false;
	private boolean updatedLocally=false;

	public static final String SCEN_BEST_CASE = "Best Case";
	public static final String SCEN_MOST_LIKELY_CASE = "Most Likely";
	public static final String SCEN_WORST_CASE = "Worst Case";

	public static final double BEST_CASE_FACTOR = 1.0;
	public static final double MOST_LIKELY_FACTOR = 0.75;
	public static final double WORST_CASE_FACTOR = 0.50;

	public static final String[] SCENARIOS = {
		SCEN_BEST_CASE, SCEN_MOST_LIKELY_CASE, SCEN_WORST_CASE
	};

	public final static int PERIOD_ALL = 0;
	public final static int PERIOD_Q1 = 1;
	public final static int PERIOD_Q2 = 2;
	public final static int PERIOD_Q3 = 3;
	public final static int PERIOD_Q4 = 4;

    public final static String[] PERIODS = new String[5];
	
	static {
		PERIODS[PERIOD_ALL] = "All Quarters";
		PERIODS[PERIOD_Q1] = "Q1 - Current Year (Jan-Mar)";
		PERIODS[PERIOD_Q2] = "Q2 - Current Year (Apr-Jun)";
		PERIODS[PERIOD_Q3] = "Q3 - Current Year (Jul-Sep)";
		PERIODS[PERIOD_Q4] = "Q4 - Current Year (Oct-Dec)";
	}

	
	public Forecast() {
		submitted=new Boolean(false);
		closeDate = new Date();
		submittedDate = new Date();
		submittedBy = "SYSTEM";
		revenue = new Integer(0);
		profit = new Integer(0);
		margin = new Double(0.00);
		scenario = SCEN_BEST_CASE;
		amountJan = new Integer(0);
		amountFeb = new Integer(0);
		amountMar = new Integer(0);
		amountApr = new Integer(0);
		amountMay = new Integer(0);
		amountJun = new Integer(0);
		amountJul = new Integer(0);
		amountAug = new Integer(0);
		amountSep = new Integer(0);
		amountOct = new Integer(0);
		amountNov = new Integer(0);
		amountDec = new Integer(0);
		Q1 = new Integer(0);
		Q2 = new Integer(0);
		Q3 = new Integer(0);
		Q4 = new Integer(0);
		modifiedBy="SYSTEM";
		modifiedDate = new Date();
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final long getPK() { return pk; }

	public final void setOppKey(long pk) { this.oppPK = pk; }
	public final long getOppKey() { return oppPK; }

	public final void setName(String n) { name = n;}
	public final String getName() { return name; }

	public final void setCloseDate(Date t) { closeDate = t; }
	public final Date getCloseDate() { return closeDate; }

	public final void setSubmitted(Boolean t) { submitted = t; }
	public final Boolean getSubmitted() { return submitted; }

	public final void setSubmittedDate(Date t) { submittedDate = t; }
	public final Date getSubmittedDate() { return submittedDate; }

	public final void setSubmittedBy(String t) { submittedBy = t; }
	public final String getSubmittedBy() { return submittedBy; }

	public final void setRevenue(Integer d) { revenue=d; }
	public final Integer getRevenue() { return revenue; }

	public final void setProfit(Integer d) { profit = d; }
	public final Integer getProfit() { return profit; }

	public final void setMargin(Double d) {  
		margin = d; 
		calcProfit();
	}
	public final Double getMargin() { return margin; }

	public final void setScenario(String s) { scenario = s; }
	public final String getScenario() { return scenario; }

	public final void setModifiedBy(String s) { modifiedBy = s; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setModifiedDate(Date s) { modifiedDate = s; }
	public final Date getModifiedDate() { return modifiedDate; }


	public final void setAmountJan(Integer i) { 
		amountJan = i; 
		calcQ1(); 
	}
	public final void setAmountFeb(Integer i) { 
		amountFeb = i; 
		calcQ1();
	}
	public final void setAmountMar(Integer i) { 
		amountMar = i; 
		calcQ1();
	}
	public final void setAmountApr(Integer i) { 
		amountApr = i; 
		calcQ2();
	}
	public final void setAmountMay(Integer i) { 
		amountMay = i; 
		calcQ2();
	}
	public final void setAmountJun(Integer i) { 
		amountJun = i; 
		calcQ2();
	}
	public final void setAmountJul(Integer i) { 
		amountJul = i; 
		calcQ3();
	}
	public final void setAmountAug(Integer i) { 
		amountAug = i; 
		calcQ3();
	}
	public final void setAmountSep(Integer i) { 
		amountSep = i; 
		calcQ3();
	}
	public final void setAmountOct(Integer i) { 
		amountOct = i; 
		calcQ4();
	}
	public final void setAmountNov(Integer i) { 
		amountNov = i; 
		calcQ4();
	}
	public final void setAmountDec(Integer i) { 
		amountDec = i; 
		calcQ4();
	}

	public final void setQ1(Integer i) { Q1 = i; }
	public final void setQ2(Integer i) { Q2 = i; }
	public final void setQ3(Integer i) { Q3 = i; }
	public final void setQ4(Integer i) { Q4 = i; }

	public final Integer getAmountJan() { return amountJan; }
	public final Integer getAmountFeb() { return amountFeb; }
	public final Integer getAmountMar() { return amountMar; }
	public final Integer getAmountApr() { return amountApr; }
	public final Integer getAmountMay() { return amountMay; }
	public final Integer getAmountJun() { return amountJun; }
	public final Integer getAmountJul() { return amountJul; }
	public final Integer getAmountAug() { return amountAug; }
	public final Integer getAmountSep() { return amountSep; }
	public final Integer getAmountOct() { return amountOct; }
	public final Integer getAmountNov() { return amountNov; }
	public final Integer getAmountDec() { return amountDec; }

	public final Integer getQ1() { return Q1; }
	public final Integer getQ2() { return Q2; }
	public final Integer getQ3() { return Q3; }
	public final Integer getQ4() { return Q4; }

	public final void setAddedLocally(boolean b) { addedLocally=b; }
	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final boolean getAddedLocally() { return addedLocally; }
	public final boolean getUpdatedLocally() { return updatedLocally; }


	public final Forecast copy() {
		Forecast copy = new Forecast();
		if (name != null)
			copy.name = new String(name);
		if (closeDate != null)
			copy.closeDate = new Date( closeDate.getTime());
		copy.revenue= new Integer(revenue.intValue());
		copy.submitted = new Boolean(submitted.booleanValue());
		copy.profit = new Integer(profit.intValue());
		copy.margin = new Double(margin.doubleValue());
		copy.submittedDate = new Date(submittedDate.getTime());
		copy.submittedBy = new String(submittedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());
		copy.modifiedBy = new String(modifiedBy);
		if (scenario != null)
			copy.scenario = new String( scenario);

		copy.amountJan = new Integer(amountJan.intValue());
		copy.amountFeb = new Integer(amountFeb.intValue());
		copy.amountMar = new Integer(amountMar.intValue());
		copy.amountApr = new Integer(amountApr.intValue());
		copy.amountMay = new Integer(amountMay.intValue());
		copy.amountJun = new Integer(amountJun.intValue());
		copy.amountJul = new Integer(amountJul.intValue());
		copy.amountAug = new Integer(amountAug.intValue());
		copy.amountSep = new Integer(amountSep.intValue());
		copy.amountOct = new Integer(amountOct.intValue());
		copy.amountNov = new Integer(amountNov.intValue());
		copy.amountDec = new Integer(amountDec.intValue());
		copy.Q1 = new Integer(Q1.intValue());
		copy.Q2 = new Integer(Q2.intValue());
		copy.Q3 = new Integer(Q3.intValue());
		copy.Q4 = new Integer(Q4.intValue());
		
		return copy;

	}

	public final void factorChange() {
		calcQ1();
		calcQ2();
		calcQ3();
		calcQ4();
	}

	public final void calcQ1() {
		int val = 
			getAmountJan().intValue() + 
			getAmountFeb().intValue() + 
			getAmountMar().intValue();
		Double temp = new Double(val * getFactor());
		setQ1(new Integer(temp.intValue()));
		calcAll();
	}

	public final void calcQ2() {
		int val = 
			getAmountApr().intValue() + 
			getAmountMay().intValue() + 
			getAmountJun().intValue();
		Double temp = new Double(val * getFactor());
		setQ2(new Integer(temp.intValue()));
		calcAll();
	}
	public final void calcQ3() {
		int val = 
			getAmountJul().intValue() + 
			getAmountAug().intValue() + 
			getAmountSep().intValue();

		Double temp = new Double(val * getFactor());
		setQ3(new Integer(temp.intValue()));
		calcAll();
	}
	public final void calcQ4() {
		int val = 
			getAmountOct().intValue() + 
			getAmountNov().intValue() + 
			getAmountDec().intValue();
		
		Double temp = new Double(val * getFactor());
		setQ4(new Integer(temp.intValue()));
		calcAll();
	}
	public final void calcAll() {
		int val = 
			getQ1().intValue() + 
			getQ2().intValue() + 
			getQ3().intValue() +
			getQ4().intValue();
	
		setRevenue(new Integer(val));

		calcProfit();
	}

	public final void calcProfit() {
		int rev = getRevenue().intValue();
		double marg = getMargin().doubleValue();
		Double temp = new Double(rev * marg);

		setProfit( new Integer(temp.intValue()));
	}


	public final double getFactor() {
		if (scenario.equals(SCEN_BEST_CASE))
			return BEST_CASE_FACTOR;
		if (scenario.equals(SCEN_MOST_LIKELY_CASE))
			return MOST_LIKELY_FACTOR;
		if (scenario.equals(SCEN_WORST_CASE))
			return WORST_CASE_FACTOR;

		Exception e = new Exception();
		e.printStackTrace();
		System.exit(0);

		return BEST_CASE_FACTOR;
	}

	public final void print() {
		System.out.println("<<Forecast>>");
		System.out.println("pk=["+getPK()+"]");
		System.out.println("Name=["+getName()+"]");
		System.out.println("Close Date="+getCloseDate());
		System.out.println("Revenue="+getRevenue());
		System.out.println("Profit="+getProfit());
		System.out.println("Margin="+getMargin());
		System.out.println("Scenario=["+getScenario()+"]");
		System.out.println("Submitted="+getSubmitted());
		System.out.println("Submit Date="+ getSubmittedDate());
		System.out.println("SubmittedBy="+ getSubmittedBy());
		System.out.println("Jan="+getAmountJan() + " Feb="+getAmountFeb());
		System.out.println("Mar="+getAmountMar() + " Apr="+getAmountApr());
		System.out.println("May="+getAmountMay() + " Jun="+getAmountJun());
		System.out.println("Jul="+getAmountJul() + " Aug="+getAmountAug());
		System.out.println("Sep="+getAmountSep() + " Oct="+getAmountOct());
		System.out.println("Nov="+getAmountNov() + " Dec="+getAmountDec());
		System.out.println("Q1="+getQ1()+" Q2="+getQ2()+" Q3="+getQ3() +" Q4="+getQ4());
		System.out.println("ModifiedBy="+ getModifiedBy());
		System.out.println("ModifiedDate="+ getModifiedDate());
	}
}
