package sellwin.domain;

import java.io.*;
import java.util.Date;
import java.util.ArrayList;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * this class holds the security info that is passed
 * back to a client upon a successful login.
 * 
 * the login 'token' is a way for subsequent server
 * calls to be secured.  See the security docs for
 * a complete description of the security model.
 *
 * the SalesPerson that is returned, holds all the
 * roles and permissions for that user.  
 */
public class Login implements Serializable {
	private long token;
	private SalesPerson sp;

	public Login() {
		//use the timestamp as a unique security token
		token = new java.util.Date().getTime();
	}

	public final long getToken() { return token; }
	public final void setToken(long t) { token = t; }

	public final SalesPerson getSalesPerson() { return sp; }
	public final void setSalesPerson(SalesPerson r) {
		sp = r;
	}

	/**
	 * @return true if the login has a sales rep role
	 */
	final public boolean isSalesRep() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.isSalesRep())
				return true;
		}
		return false;
	}

	/**
	 * @return true if the login has a sales mgr role
	 */
	final public boolean isSalesMgr() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.isSalesMgr())
				return true;
		}
		return false;
	}
	/**
	 * @return true if the login has a sales support role
	 */
	final public boolean isSalesSupport() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.isSalesSupport())
				return true;
		}
		return false;
	}
	/**
	 * @return true if the login has a system admin role
	 */
	final public boolean isSystemAdmin() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.isSystemAdmin())
				return true;
		}
		return false;
	}
	/**
	 * @return true if the login has a marketing rep role
	 */
	final public boolean isMarketingRep() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			if (role.isMarketingRep())
				return true;
		}
		return false;
	}

	/**
	 * @return true if the forecast permission accepts 'reads'
	 */
	final public   boolean forecastReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_FORECAST)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the forecast permission accepts 'writes'
	 */
	final public   boolean forecastWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_FORECAST)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the quote permission accepts 'reads'
	 */
	final public  boolean quoteReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_QUOTE)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the quote permission accepts 'writes'
	 */
	final public  boolean quoteWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_QUOTE)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the activity permission accepts 'reads'
	 */
	final public  boolean activityReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_ACTIVITY)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}
	/**
	 * @return true if the activity permission accepts 'writes'
	 */
	final public  boolean activityWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_ACTIVITY)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the basic admin permission accepts 'reads'
	 */
	final public  boolean basicAdminReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_BASIC_ADMIN)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the basic admin permission accepts 'writes'
	 */
	final public  boolean basicAdminWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_BASIC_ADMIN)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the user admin permission accepts 'reads'
	 */
	final public  boolean userAdminReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_USER_ADMIN)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}
	/**
	 * @return true if the user admin permission accepts 'writes'
	 */
	final public  boolean userAdminWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_USER_ADMIN)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the order permission accepts 'writes'
	 */
	final public  boolean orderWritable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_ORDER)) 
					if (perm.getWrite())
						return true;
			}
		}
		return false;
	}

	/**
	 * @return true if the order permission accepts 'reads'
	 */
	final public  boolean orderReadable() {
		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		RolePermission perm;
		ArrayList perms;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			perms = role.getPermissions();
			for (int j=0;j<perms.size();j++) {
				perm = (RolePermission)perms.get(j);
				if (perm.getName().equals(RolePermission.PERM_ORDER)) 
					if (perm.getRead())
						return true;
			}
		}
		return false;
	}

	final public void print() {
		System.out.println("<<<Login Object>>>");
		System.out.println("token:"+token);

		ArrayList roles = getSalesPerson().getUserRoles();
		UserRole role;
		for (int i=0;i<roles.size();i++) {
			role = (UserRole)roles.get(i);
			role.print();
		}
		System.out.println("<<<End Login Object>>>");
	}


}
