package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class contains data about a product that will
 * be used to do quoting.
 */
public class Product implements Serializable {
	private long pk;
	private String group;
	private String line;
	private String name;
	private String modelNo;
	private Double cost;
	private Double price;
	private String desc;
	private String modifiedBy;
	private Date modifiedDate;

	public Product() {
		this("hi", "you", "dude");
	}

	public Product(String g, String l, String n) {
		group = g;
		line = l;
		name = n;
	
		cost = new Double(0.00);
        price = new Double(0.00);
		modifiedDate = new Date();
	}

	public void clear() {
		name = "";
		group = "";
		line = "";
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setGroup(String g) { group = g; }
	public final void setLine(String g) { line = g; }
	public final void setName(String name) { this.name = name; }
 	public final void setModelNo(String no) { this.modelNo = no; }
  	public final void setCost(Double d) { cost = d; }
    public final void setPrice(Double d) {  price = d; }
    public final void setDesc(String s) { desc = s; }
	public final void setModifiedDate(Date d) { modifiedDate = d; }
	public final void setModifiedBy(String s) { modifiedBy = s; }

    public final long getPK() { return pk; }
	public final String getLine() { return line; }
	public final String getGroup() { return group; }
	public final String getName() { return name; }
 	public final String getModelNo() { return modelNo; }
    public final Double getCost() { return cost; }
    public final Double getPrice() { return price; }
    public final String getDesc() { return desc; }
	public final String getModifiedBy() { return modifiedBy; }
	public final Date getModifiedDate() { return modifiedDate; }

	public final Product copy() {
		Product copy = new Product(new String(getGroup()), new String(getLine()), new String(getName()));
		if (modelNo != null)
			copy.modelNo = new String(modelNo);
		
        copy.price= new Double(price.doubleValue());
        copy.cost = new Double(cost.doubleValue());
        if (desc != null)
            copy.desc = new String(desc);

		copy.modifiedBy =new String(modifiedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());
		return copy;
	}

   public final void print() {
        System.out.println("<<Product>>");
        System.out.println("pk=["+getPK()+"]");
        System.out.println("Name=["+getName()+"]");
        System.out.println("Model No=["+getModelNo()+"]");
        System.out.println("Group=["+getGroup()+"]");
        System.out.println("Line=["+getLine()+"]");
        System.out.println("Price="+getPrice());
        System.out.println("Cost="+getCost());
        System.out.println("Model No=["+getModelNo()+"]");
        System.out.println("Desc=["+getDesc()+"]");
        System.out.println("ModifiedBy=["+getModifiedBy()+"]");
        System.out.println("ModifiedDate=["+getModifiedDate()+"]");
    }


}
