package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class relates to a quote in Sellwin.  A quote is
 * owned by a particular Opportunity.  A quote object relates
 * to the quote table in the database;
 */
public class Quote implements  Serializable {
	private long pk;
	private long oppPK;
	private String name;
	private ArrayList lines = new ArrayList();
	private Date modifiedDate;
	private String modifiedBy;
	private boolean modified;
	private boolean updatedLocally=false;
	private boolean addedLocally=false;

	public Quote() {
		modifiedDate = new Date();
		modified = false;
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setOppPK(long pk) { this.oppPK = pk; }
	public final long getOppPK() { return oppPK; }
	public final void setName(String n) { name = n;}
	public final void addLine(QuoteLine t) {
		lines.add(t);
	}
	public final void setModified(boolean t) { modified = t; }
	public final boolean getModified() { return modified; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date d) { modifiedDate = d; }

	public final void deleteLine(long linePK) 
		throws AngError {

		ArrayList lines = getLines();
		QuoteLine line=null;

		for (int i=0;i<lines.size();i++) {
			line = (QuoteLine)(lines.get(i));
			if (line.getPK() == linePK) {
				lines.remove(i);
				return;
			}
		}
		throw new AngError("deleteLine "+linePK+ " not found");
	}

	public final double calcSubTotal() {
		ArrayList lines = getLines();
		QuoteLine line=null;
		double subTotal=0.00;

		for (int i=0;i<lines.size();i++) {
			line = (QuoteLine)(lines.get(i));
			subTotal = subTotal + 
					(line.getQuantity().intValue() * 
					line.getProduct().getPrice().doubleValue());
		}
		
		return subTotal;
	}
		

	public final String getName() { return name; }
	public final ArrayList getLines() { return lines; }
	public final long getPK() { return pk; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }
	public final boolean getUpdatedLocally() { return updatedLocally; }
	public final boolean getAddedLocally() { return addedLocally; }

	public final Quote copy() {
		Quote copy = new Quote();
		copy.setPK(getPK());
		if (name != null)
			copy.name = new String(name);
		if (modifiedDate != null)
			copy.modifiedDate = new Date(modifiedDate.getTime());
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		QuoteLine lineCopy;
		QuoteLine line;
		for (int i=0;i<lines.size();i++) {
			line = (QuoteLine)lines.get(i);
			lineCopy = line.copy();
			copy.lines.add(lineCopy);
		}
		return copy;
	}

	public final void print() {
		System.out.println("<<Quote>>");
		System.out.println("pk=["+getPK()+"]");
		System.out.println("opppk=["+getOppPK()+"]");
		System.out.println("Name=["+getName()+"]");
		System.out.println("Modified =["+getModified()+"]");
		System.out.println("Modified By =["+getModifiedBy()+"]");
		System.out.println("Modified Date =["+getModifiedDate()+"]");
		QuoteLine line;
		for (int i=0;i<lines.size();i++)  {
			line = (QuoteLine)lines.get(i);
			line.print();
		}
	}
}
