package sellwin.domain;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.swing.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents a quote's line item in
 * Sellwin.  A Quote line is stored in the 'quote_line' table
 * in the database.
 */
public class QuoteLine implements  Serializable {
	private long pk;
	private long quotePK;
	private Product product;
	private Integer quantity;
	private Double totalPrice;
	private boolean modified;
	private String modifiedBy;
	private Date modifiedDate;
	private boolean addedLocally=false;
	private boolean updatedLocally=false;

	public QuoteLine() {
		totalPrice = new Double(12.00);
		quantity = new Integer(1);
		modified = false;
		modifiedDate = new Date();
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final void setQuotePK(long pk) { quotePK = pk; }
	public final long getQuotePK() { return quotePK; }
	public final Product getProduct() { return product; }
	public final void setProduct(Product p) { product = p; }
	public final void setQuantity(Integer d) { 
		quantity=d; 
		calcTotal();
	}

	public final void setTotalPrice(Double d) { totalPrice = d; }
	public final void setModified(boolean f) { modified = f; }
	public final void setModifiedBy(String f) { modifiedBy = f; }
	public final void setModifiedDate(Date f) { modifiedDate = f; }
	

	public final long getPK() { return pk; }
	public final Integer getQuantity() { return quantity; }
	public final Double getTotalPrice() { return totalPrice; }
	public final boolean getModified() { return modified; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setUpdatedLocally(boolean b) { updatedLocally=b; }
	public final void setAddedLocally(boolean b) { addedLocally=b; }

	private final void calcTotal() {
		double u = product.getPrice().doubleValue();
		int q = quantity.intValue();
		setTotalPrice(new Double(u * q));
	}

	public final QuoteLine copy() {
		QuoteLine copy = new QuoteLine();
		copy.product = product.copy();
		copy.quantity= new Integer(quantity.intValue());
		if (modifiedBy != null)
			copy.modifiedBy = new String(modifiedBy);
		copy.modifiedDate = new Date(modifiedDate.getTime());
		return copy;
	}

	public final void print() {
		System.out.println("<<Quote Line>>");
		System.out.println("pk=["+getPK()+"]");
		product.print();
		System.out.println("Quantity="+getQuantity());
		System.out.println("Modified =["+getModified()+"]");
		System.out.println("Modified  =["+modifiedBy + modifiedDate+"]");
	}
}
