package sellwin.domain;

import java.util.*;
import java.io.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.


/**
 * This class represents the various 'groups' that are built
 * to show which sales persons are logically grouped together
 * for some purpose (e.g.  a group responsible for some opportunity )
 *
 * This class holds the columns from the 'user_group' database table.
 */
public class UserGroup implements Serializable {
	private long pk;
	private String name;
	private ArrayList users = new ArrayList(); //list of SalesPerson PKs
	private String modifiedBy;
	private Date modifiedDate;

	public UserGroup() {
	}

	public UserGroup(String n) {
		name = n;
		modifiedDate = new Date();
		modifiedBy = "";
	}

	public final void setPK(long pk) { this.pk = pk; }
	public final long getPK() { return pk; }
	public final void setModifiedBy(String by) { modifiedBy = by; }
	public final void setModifiedDate(Date dt) { modifiedDate = dt; }
	public final Date getModifiedDate() { return modifiedDate; }
	public final String getModifiedBy() { return modifiedBy; }

	public final void setName(String name) {
		this.name = name;
	}

	public final String getName() { return name; }

	public final ArrayList getUsers() {
		return users;
	}

	public final void addUser(Long pk) {
		users.add(pk);
	}

	public static UserGroup find(ArrayList groups, String key) {
		UserGroup u = null;
		for (int i=0;i<groups.size();i++) {
			u = (UserGroup)groups.get(i);
			if (u.getName().equals(key))
				return u;
		}

		return null;
	}

	public static int findUser(UserGroup group, long userPK) {
		ArrayList users = group.getUsers();
		Long u = null;
		for (int i=0;i<users.size();i++) {
			u = (Long)users.get(i);
			if (u.longValue() == userPK)
				return i;
		}	
		return -1;
	}

	public final void print() {
		System.out.println("UserGroup="+getName() + " pk=" + pk);
		for (int i=0;i<users.size();i++) 
			System.out.println("user pk="+users.get(i));
	}

	public final UserGroup copy() {
		UserGroup copy = new UserGroup(new String(name));
		copy.setModifiedBy(new String(modifiedBy));
		copy.setModifiedDate(new Date(modifiedDate.getTime()));
		Long userPK, userPKCopy;
		for (int i=0;i<users.size();i++) {
			userPK = (Long)users.get(i);
			userPKCopy = new Long(userPK.longValue());
			copy.addUser(userPKCopy);
		}
		return copy;
	}
}

