package sellwin.gui;

import sellwin.domain.*;
import sellwin.server.*;
import javax.swing.*;
import javax.swing.event.*;
import java.rmi.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This is the GUI's small 'about' dialog that shows
 * the version number.
 */

public class AboutDialog extends JDialog implements GUIChars {
    private JPanel buttonPanel;
    private JButton closeButton;
    private JLabel versionLabel;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel mainPanel;
    
    /** Creates new form AboutDialog */
    public AboutDialog(MainWindow parent) {
        super(parent, false);
        initComponents();
		setLang();
		setColors();
		setFonts();
		setSize(236, 143);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonPanel = new JPanel();
        closeButton = new JButton();
		Whiteboard wb = MainWindow.getWhiteboard();
        closeButton.setText(wb.getLang().getString("close"));
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
        		setVisible(false);
		        dispose();
            }
        });

        mainPanel = new JPanel();
        versionLabel = new JLabel();
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        closeButton.setText("Close");
        buttonPanel.add(closeButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        mainPanel.setLayout(new java.awt.GridBagLayout());

        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        versionLabel.setText("SellWin Version 1.0.4");
        versionLabel.setHorizontalAlignment(SwingConstants.CENTER);
        mainPanel.add(versionLabel, new java.awt.GridBagConstraints());

        jLabel1.setText("Open Sourced at http://sourceforge.net/projects/sellwincrm");
        jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mainPanel.add(jLabel1, gridBagConstraints);

        jLabel2.setText("http://www.open-app.com");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        mainPanel.add(jLabel2, gridBagConstraints);

        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);

        pack();
    }
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }

	public final void setLang() {
	}
	public final void setColors() {
	}
	public final void setFonts() {
		jLabel2.setFont(MainWindow.LABEL_FONT);
		jLabel1.setFont(MainWindow.LABEL_FONT);
		versionLabel.setFont(MainWindow.LABEL_FONT);
	}
}
