package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the table to
 * object mapping for the Activities listed
 * on the Activity panel.  
 */
public class ActivityTableModel extends AbstractTableModel {
	public static int START_DT_COLUMN = 1;

	private String[] columnNames = {
	"Subject", "Start Dt", "Type", "Place", "Message", "Alarm", "Duration", "Updated By" };

	private ArrayList wholeList = null;
	private Activity activity = new Activity("test");

	/**
	 * construct a table model for the activity table 
	 * @param wholelist a list of Activity objects to
	 * build the table with
	 */
	public ActivityTableModel(ArrayList wholeList) {
		setLang();
		this.wholeList = wholeList;
		activity.setSubject("subject");
		activity.setType("type");
		activity.setPlace("place");
		activity.setMessage("message");
		activity.setStartDate(new java.util.Date());
		activity.setDuration(new Integer(15));
		activity.setModifiedBy("updatedby");
	}


	/**
	 * add an Activity to the table 
	 * @param f an Activity to add
	 * @exception class-name description
	 */
	public void addActivity(Activity f) {
		wholeList.add(f);
	}

	/**
	 * get an Activity using an index into
	 * the current list of Activities presented
	 * by this table
	 * @param index the index key
	 * @return the Activity that was at the index
	 */
	public Activity getActivity(int index) {
		return (Activity)(wholeList.get(index));
	}

	/**
	 * delete an Activity from the table's list
	 * @param index the index key
	 */
	public void deleteActivity(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the list of Activity objects used by the list 
	 * @return the ArrayList of Activity objects
	 */
	public ArrayList getActivitys() { 
		return wholeList;
	}

	/**
	 * get a table cell value 
	 * @param row the cell's row index
	 * @param col the cell's column index
	 * @return the value at that cell location
	 */
	public Object getValueAt(int row, int col) {
		Activity activity=null;
		activity = (Activity)wholeList.get(row);
		switch (col) {
			case 0: //subject
				return activity.getSubject();
			case 1: //start date
				return activity.getStartDate();
			case 2: //type
				return activity.getType();
			case 3: //Place
				return activity.getPlace();
			case 4: //message
				return activity.getMessage();
			case 5: //alarm flag
				return activity.getAlarm();
			case 6: //duration
				return activity.getDuration();
			case 7: //updated by
				return activity.getModifiedBy();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	public int getRowCount() {
		return wholeList.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	public String getColumnName(int col) {
		return columnNames[col];
	}

	public Class getColumnClass(int col) {
		switch (col) {
			case 0: //subject
				return activity.getSubject().getClass();
			case 1: //start date
				return activity.getStartDate().getClass();
			case 2: //type
				return activity.getType().getClass();
			case 3: //place
				return activity.getPlace().getClass();
			case 4: //message
				return activity.getMessage().getClass();
			case 5: //alarm flag
				return activity.getAlarm().getClass();
			case 6: //duration
				return activity.getDuration().getClass();
			case 7: //updated by
				return activity.getModifiedBy().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	public void setValueAt(Object value, int row, int col) {
		Activity activity = null;
		activity = (Activity)wholeList.get(row);
		switch (col) {
			case 0: //subject
				activity.setSubject((String)value);
				break;
			case 1: //start date
				if (value == null) value = new Date();
				activity.setStartDate((Date)value);
				break;
			case 2: //type
				activity.setType((String)value);
				break;
			case 3: //place
				activity.setPlace((String)value);
				break;
			case 4: //message
				activity.setMessage((String)value);
				break;
			case 5: //alarm flag
				activity.setAlarm((Boolean)value);
				break;
			case 6: //duration
				activity.setDuration((Integer)value);
				break;
			case 7: //updated by
				activity.setModifiedBy((String)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	public boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		if ((col == 0) || (col == 7)) return false;

		return  true;
	}

	public void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
	
		columnNames[0] = wb.getLang().getString("subject");
		columnNames[1] = wb.getLang().getString("startDate");
		columnNames[2] = wb.getLang().getString("type");
		columnNames[3] = wb.getLang().getString("place");
		columnNames[4] = wb.getLang().getString("message");
		columnNames[5] = wb.getLang().getString("alarm");
		columnNames[6] = wb.getLang().getString("duration");
		columnNames[7] = wb.getLang().getString("updatedBy");
	}
}
