package sellwin.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import sellwin.domain.*;
import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Address maintenance
 * panel used throughout all the GUI for different
 * types of addresses.
 */
public class AddressPanel extends javax.swing.JPanel implements GUIChars {
    private JLabel nameLabel;
    private JLabel addrLabel;
    private JLabel addrExtLabel;
    private JLabel cityLabel;
    private JLabel phoneLabel;
    private JLabel countryLabel;

    private JTextField lastNameField;
    private JComboBox stateCombo;
    private JTextField phoneField;
    private JTextField miField;
    private JTextField firstNameField;
    private JTextField addrField;
    private JTextField addrExtField;
    private JTextField cityField;
    private JTextField zipField;
    private JTextField zip4Field;
    private JTextField countryField;

	private Address origAddress;
	private boolean modified=false;

    /** 
	 * construct an AddressPanel
 	 */
    public AddressPanel() {
        initComponents();
		setFonts();
		setColors();
		setLang();
    }

	/**
	 * construct and initialize the panel's components  
	 */
    private final void initComponents() {
        nameLabel = new JLabel();
        addrLabel = new JLabel();
        addrExtLabel = new JLabel();
        cityLabel = new JLabel();
        phoneLabel = new JLabel();
        countryLabel = new JLabel();
        lastNameField = new JTextField();
        stateCombo = new JComboBox();
        phoneField = new JTextField();
        countryField = new JTextField();
        miField = new JTextField();
        firstNameField = new JTextField();
        addrField = new JTextField();
        addrExtField = new JTextField();
        cityField = new JTextField();
        zipField = new JTextField();
        zip4Field = new JTextField();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        nameLabel.setText("Name (Last, MI, First)");
        nameLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(nameLabel, gridBagConstraints1);
       
		JPanel namePanel = new JPanel(new GridBagLayout());
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = GridBagConstraints.WEST;
        add(namePanel, gridBagConstraints1);
		
 
        addrLabel.setText("Address");
        addrLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(addrLabel, gridBagConstraints1);
        
        addrExtLabel.setText("Ext. Address");
        addrExtLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(addrExtLabel, gridBagConstraints1);
        
        cityLabel.setText("City, State, Zip");
        cityLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(cityLabel, gridBagConstraints1);
       
		JPanel cityPanel = new JPanel(new GridBagLayout());
		gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = GridBagConstraints.WEST;
        add(cityPanel, gridBagConstraints1);
 
        phoneLabel.setText("Phone");
        phoneLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(phoneLabel, gridBagConstraints1);

        countryLabel.setText("Country");
        countryLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(countryLabel, gridBagConstraints1);
        
        lastNameField.setText("");
		lastNameField.setMinimumSize(new Dimension(100,Prefs.FIELD_HEIGHT));
		lastNameField.setPreferredSize(new Dimension(100,Prefs.FIELD_HEIGHT));
        GridBagConstraints gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        namePanel.add(lastNameField, gridBagConstraints2);
        
        miField.setText("");
		miField.setColumns(2);
		miField.setMinimumSize(new Dimension(40,Prefs.FIELD_HEIGHT));
		miField.setPreferredSize(new Dimension(40,Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0,7,0,7);
        namePanel.add(miField, gridBagConstraints2);
        
        firstNameField.setText("");
		firstNameField.setMinimumSize(new Dimension(100,Prefs.FIELD_HEIGHT));
		firstNameField.setPreferredSize(new Dimension(100,Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        namePanel.add(firstNameField, gridBagConstraints2);


        phoneField.setText("");
		phoneField.setMinimumSize(new Dimension(100,Prefs.FIELD_HEIGHT));
		phoneField.setPreferredSize(new Dimension(100,Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(phoneField, gridBagConstraints1);

        countryField.setText("");
		countryField.setMinimumSize(new Dimension(100,Prefs.FIELD_HEIGHT));
		countryField.setPreferredSize(new Dimension(100,Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(countryField, gridBagConstraints1);
        

        addrField.setText("");
		addrField.setMinimumSize(new Dimension(200,Prefs.FIELD_HEIGHT));
		addrField.setPreferredSize(new Dimension(200,Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(addrField, gridBagConstraints1);

        addrExtField.setText("");
		addrExtField.setMinimumSize(new Dimension(200,Prefs.FIELD_HEIGHT));
		addrExtField.setPreferredSize(new Dimension(200,Prefs.FIELD_HEIGHT));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(addrExtField, gridBagConstraints1);

        cityField.setText("");
		cityField.setMinimumSize(new Dimension(100,Prefs.FIELD_HEIGHT));
		cityField.setPreferredSize(new Dimension(100,Prefs.FIELD_HEIGHT));
        GridBagConstraints gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        cityPanel.add(cityField, gridBagConstraints3);

        stateCombo.setModel(new DefaultComboBoxModel(Address.STATES));
		stateCombo.setMinimumSize(new Dimension(50,Prefs.FIELD_HEIGHT));
		stateCombo.setPreferredSize(new Dimension(50,Prefs.FIELD_HEIGHT));
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0,5,0,5);
        cityPanel.add(stateCombo, gridBagConstraints3);

        zipField.setText("");
		zipField.setMinimumSize(new Dimension(80,Prefs.FIELD_HEIGHT));
		zipField.setPreferredSize(new Dimension(80,Prefs.FIELD_HEIGHT));
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(0,5,0,5);
        cityPanel.add(zipField, gridBagConstraints3);

        zip4Field.setText("");
		zip4Field.setMinimumSize(new Dimension(40,Prefs.FIELD_HEIGHT));
		zip4Field.setPreferredSize(new Dimension(40,Prefs.FIELD_HEIGHT));
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 0;
        cityPanel.add(zip4Field, gridBagConstraints3);

    }

	/**
	 * set the screen widget's fonts
	 */
	public final void setFonts() {
    	nameLabel.setFont(MainWindow.LABEL_FONT);
	    addrLabel.setFont(MainWindow.LABEL_FONT);
   	 	addrExtLabel.setFont(MainWindow.LABEL_FONT);
    	cityLabel.setFont(MainWindow.LABEL_FONT);
    	phoneLabel.setFont(MainWindow.LABEL_FONT);
    	lastNameField.setFont(MainWindow.FIELD_FONT);
    	stateCombo.setFont(MainWindow.FIELD_FONT);
    	phoneField.setFont(MainWindow.FIELD_FONT);
    	miField.setFont(MainWindow.FIELD_FONT);
    	firstNameField.setFont(MainWindow.FIELD_FONT);
    	addrField.setFont(MainWindow.FIELD_FONT);
    	addrExtField.setFont(MainWindow.FIELD_FONT);
    	cityField.setFont(MainWindow.FIELD_FONT);
    	zipField.setFont(MainWindow.FIELD_FONT);
    	zip4Field.setFont(MainWindow.FIELD_FONT);
    	countryField.setFont(MainWindow.FIELD_FONT);
    	countryLabel.setFont(MainWindow.LABEL_FONT);
	}

	/**
	 *  set the screen widget's colors
	 */
	public final void setColors() {
        countryLabel.setForeground(MainWindow.LETTERS);
    	nameLabel.setForeground(MainWindow.LETTERS);
	    addrLabel.setForeground(MainWindow.LETTERS);
   	 	addrExtLabel.setForeground(MainWindow.LETTERS);
    	cityLabel.setForeground(MainWindow.LETTERS);
    	phoneLabel.setForeground(MainWindow.LETTERS);
    	stateCombo.setBackground(Color.white);
    	countryLabel.setBackground(Color.white);
	}

	/**
	 * set the panel's components to show the
	 * value of a given Address
	 * @param a the Address we are to display
	 */
	public final void setAddress(Address a) {
	
		origAddress = a;

    	Utility.strSet(lastNameField, a.getLastName());
	    stateCombo.setSelectedItem(a.getState());
   	 	Utility.strSet(phoneField, a.getPhone());
   	 	Utility.strSet(miField, a.getMiddleInitial());
   	 	Utility.strSet(firstNameField, a.getFirstName());
    	Utility.strSet(addrField, a.getAddressLine1());
    	Utility.strSet(addrExtField, a.getAddressLine2());
    	Utility.strSet(cityField, a.getCity());
    	Utility.strSet(zipField, a.getZip());
    	Utility.strSet(zip4Field, a.getZip4());
    	Utility.strSet(countryField, a.getCountry());
	}


	/**
	 * get the Address currently being shown on
	 * the screen
	 * @return an Address containing the screen's contents
	 */
	public final Address getAddress() {

		Address a = new Address();
    	a.setLastName(lastNameField.getText());
	    a.setState((String)(stateCombo.getSelectedItem()));
   	 	a.setPhone(phoneField.getText());
   	 	a.setMiddleInitial(miField.getText());
   	 	a.setFirstName(firstNameField.getText());
    	a.setAddressLine1(addrField.getText());
    	a.setAddressLine2(addrExtField.getText());
    	a.setCity(cityField.getText());
    	a.setZip(zipField.getText());
    	a.setZip4(zip4Field.getText());
    	a.setCountry(countryField.getText());

		if (origAddress == null)
			a.setModified(true);
		else
		if (a.diff(origAddress))
			a.setModified(true);

		return a;
	}

	/**
	 * clear the screen's widgets 
	 */
	public final void clear() {
		modified=false;
    	lastNameField.setText("");
	    stateCombo.setSelectedIndex(0);
   	 	phoneField.setText("");
   	 	miField.setText("");
   	 	firstNameField.setText("");
    	addrField.setText("");
    	addrExtField.setText("");
    	cityField.setText("");
    	zipField.setText("");
    	zip4Field.setText("");
    	countryField.setText("");
	}

	/**
	 * set the screen's text to some language
	 */
	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		nameLabel.setText(wb.getLang().getString("fullName"));
	    addrLabel.setText(wb.getLang().getString("address"));
		addrExtLabel.setText(wb.getLang().getString("extAddress"));
		cityLabel.setText(wb.getLang().getString("cityStateZip"));
		phoneLabel.setText(wb.getLang().getString("phone"));
		countryLabel.setText(wb.getLang().getString("country"));
	}

	/**
	 * check to see if the panel was possibly updated
	 * @return true if the panel was deemed modified
	 */
	 public final boolean isModified() { return modified; }
}
