package sellwin.gui;

import sellwin.utils.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class shows a popup dialog box that contains a
 * calendar and time selection.  The user selects the 
 * day and time using this dialog.
 */
public class CalendarDialog extends javax.swing.JDialog implements GUIChars {

	private static final int HEIGHT = 26; 
	private static final int WIDTH = 25;

	private static final String[] HOURS = {
		"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
		"12" };
	private static final String[] MINUTES = { 
		"00", "01", "02", "03", "04", "05", "06", "07", "08", "09",
		"10", "11", "12", "13", "14", "15", "16", "17", "18", "19",
		"20", "21", "22", "23", "24", "25", "26", "27", "28", "29",
		"30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
		"40", "41", "42", "43", "44", "45", "46", "47", "48", "49",
		"50", "51", "52", "53", "54", "55", "56", "57", "58", "59",
	 };
	private static final String[] AM_PM = { "AM", "PM" };

	private static java.awt.Dimension STANDARD_DIMENSION = new Dimension(HEIGHT, WIDTH);

	private Date date;
	private Calendar thisMonthCal = Calendar.getInstance();
	private Calendar currentCal = Calendar.getInstance();

    private JPanel buttonPanel;
    private JButton previousButton, nextButton;
    private JLabel monthYearLabel;
	private static final int MAX_BUTTONS=35;
    private ArrayList dayButtons = new ArrayList();
    private JPanel dayButtonPanel;
    private JPanel timePanel;
    private JLabel sundayLabel;
    private JLabel mondayLabel;
    private JLabel tuesdayLabel;
    private JLabel wednesdayLabel;
    private JLabel thursdayLabel;
    private JLabel fridayLabel;
    private JLabel saturdayLabel;
    private JComboBox hoursCombo, minutesCombo, ampmCombo;
	private Whiteboard wb=null;

	private DateEditorDialogListener myEditor;

	/**
     * Creates new form CalendarDialog 
	 * @param parent the parent to this dialog
	 * @param editor the component that is working with this dialog
	 * @param modal is this dialog modal or not
	 */
    public CalendarDialog(java.awt.Frame parent, DateEditorDialogListener editor, boolean modal) {
        super(parent, modal);
		myEditor = editor;
		wb = MainWindow.getWhiteboard();

		if (wb.getLang() == null)
			LogWrite.write("lang is null at this point");
		setTitle(wb.getLang().getString("calendarSelection"));

        initComponents();

		setSize(290, 190);

		setMonthLabel();
		updateDayButtons();

		nextButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					currentCal.add(Calendar.MONTH, 1);
					setMonthLabel();
					updateDayButtons();
				}
			}
		);

		previousButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					currentCal.add(Calendar.MONTH, -1);
					setMonthLabel();
					updateDayButtons();
				}
			}
		);
    }

    /** 
	 * This method is called from within the constructor to
     * initialize the form.
     */
    private final void initComponents() {
        buttonPanel = new JPanel();
        previousButton = new JButton();
        monthYearLabel = new JLabel();
        nextButton = new JButton();
        dayButtonPanel = new JPanel();
        timePanel = new JPanel();

		hoursCombo = new JComboBox(HOURS);
		minutesCombo = new JComboBox(MINUTES);
		minutesCombo.setMaximumRowCount(10);
		ampmCombo = new JComboBox(AM_PM);

        sundayLabel = new JLabel("Sun", SwingConstants.CENTER);
        	sundayLabel.setPreferredSize(STANDARD_DIMENSION);
        	sundayLabel.setMinimumSize(STANDARD_DIMENSION);
        	sundayLabel.setMaximumSize(STANDARD_DIMENSION);
        mondayLabel = new JLabel("Mon", SwingConstants.CENTER);
        	mondayLabel.setPreferredSize(STANDARD_DIMENSION);
        	mondayLabel.setMinimumSize(STANDARD_DIMENSION);
			mondayLabel.setMaximumSize(STANDARD_DIMENSION);
        tuesdayLabel = new JLabel("Tue", SwingConstants.CENTER);
        	tuesdayLabel.setPreferredSize(STANDARD_DIMENSION);
        	tuesdayLabel.setMinimumSize(STANDARD_DIMENSION);
			tuesdayLabel.setMaximumSize(STANDARD_DIMENSION);
        wednesdayLabel = new JLabel("Wed", SwingConstants.CENTER);
        	wednesdayLabel.setPreferredSize(STANDARD_DIMENSION);
        	wednesdayLabel.setMinimumSize(STANDARD_DIMENSION);
			wednesdayLabel.setMaximumSize(STANDARD_DIMENSION);
        thursdayLabel = new JLabel("Thu", SwingConstants.CENTER);
        	thursdayLabel.setPreferredSize(STANDARD_DIMENSION);
        	thursdayLabel.setMinimumSize(STANDARD_DIMENSION);
			thursdayLabel.setMaximumSize(STANDARD_DIMENSION);
        fridayLabel = new JLabel("Fri", SwingConstants.CENTER);
        	fridayLabel.setPreferredSize(STANDARD_DIMENSION);
        	fridayLabel.setMinimumSize(STANDARD_DIMENSION);
			fridayLabel.setMaximumSize(STANDARD_DIMENSION);
        saturdayLabel = new JLabel("Sat", SwingConstants.CENTER);
        	saturdayLabel.setPreferredSize(STANDARD_DIMENSION);
        	saturdayLabel.setMinimumSize(STANDARD_DIMENSION);
			saturdayLabel.setMaximumSize(STANDARD_DIMENSION);
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        previousButton.setText("<");
        buttonPanel.add(previousButton);
        
        monthYearLabel.setText("Jan 2002");
        buttonPanel.add(monthYearLabel);
        
        nextButton.setText(">");
        buttonPanel.add(nextButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.NORTH);
        
        dayButtonPanel.setLayout(new java.awt.GridLayout(6, 7, 0, 0));
       
        dayButtonPanel.add(sundayLabel);
        dayButtonPanel.add(mondayLabel);
        dayButtonPanel.add(tuesdayLabel);
        dayButtonPanel.add(wednesdayLabel);
        dayButtonPanel.add(thursdayLabel);
        dayButtonPanel.add(fridayLabel);
        dayButtonPanel.add(saturdayLabel);

        timePanel.add(hoursCombo);
        timePanel.add(minutesCombo);
        timePanel.add(ampmCombo);

		JButton butt; 
		ButtonPressAction buttonPressAction = new ButtonPressAction();
		for (int i=0;i<MAX_BUTTONS;i++) {
			butt = new JButton(Integer.toString(i));
			butt.addActionListener(buttonPressAction);
        	dayButtons.add(butt);
        	butt.setMargin(new Insets(0, 0, 0, 0));
        	butt.setPreferredSize(STANDARD_DIMENSION);
        	butt.setMaximumSize(STANDARD_DIMENSION);
        	butt.setMinimumSize(STANDARD_DIMENSION);
        	dayButtonPanel.add(butt);
		}
        
        
        getContentPane().add(dayButtonPanel, java.awt.BorderLayout.CENTER);
        getContentPane().add(timePanel, java.awt.BorderLayout.SOUTH);
        
        pack();
    }

	/**
	 * close the dialog  
	 * @param evt the WindowEvent we get when called
	 */
    private final void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }


	/**
	 * set the date displayed by the dialog 
	 * not implemented yet
	 * it should set the screen to the passed in month
	 * @param d the date we are to display
	 */
	public final void setDate(Date d) {
		this.date = d;
		Calendar cal = new GregorianCalendar();
		cal.setTime(d);
		int hour = cal.get(Calendar.HOUR);
		hoursCombo.setSelectedItem(Integer.toString(hour));
		int minute = cal.get(Calendar.MINUTE);
		minutesCombo.setSelectedItem(Integer.toString(minute));
		int ampm = cal.get(Calendar.AM_PM);
		if (ampm == Calendar.PM)
			ampmCombo.setSelectedItem("PM");
		else
			ampmCombo.setSelectedItem("AM");
	}

	/**
	 * get the date from the dialog  
	 * @return the Date 
	 */
	public final Date getDate() {
		return date;
	}

	/**
	 * set the month's label to display 
	 */
	private final void setMonthLabel() {
	
		Date d = currentCal.getTime();
		SimpleDateFormat formatter = new SimpleDateFormat("MMM yyyy");
		monthYearLabel.setText(formatter.format(d));		
	}

	/**
	 * update the day button text labels on the screen 
	 */
	private final void updateDayButtons() {
		boolean thisMonth=false;

		if ((currentCal.get(Calendar.YEAR) == thisMonthCal.get(Calendar.YEAR)) &&
			(currentCal.get(Calendar.MONTH) == thisMonthCal.get(Calendar.MONTH))) 
			thisMonth=true;
	
		currentCal.set(Calendar.DAY_OF_MONTH, 1); //go to first day of month
		int day_of_week = currentCal.get(Calendar.DAY_OF_WEEK);
		int startingAt=0;

		//initialize all day buttons to blank
		JButton dayButton;
		for (int i=0;i<dayButtons.size();i++) {
			dayButton = (JButton)dayButtons.get(i);
			dayButton.setText("");
		}

		//figure out which day button we start numbering at
		switch (day_of_week) {
			case Calendar.MONDAY:
				startingAt = 1;
				break;
			case Calendar.TUESDAY:
				startingAt = 2;
				break;
			case Calendar.WEDNESDAY:
				startingAt = 3;
				break;
			case Calendar.THURSDAY:
				startingAt = 4;
				break;
			case Calendar.FRIDAY:
				startingAt = 5;
				break;
			case Calendar.SATURDAY:
				startingAt = 6;
				break;
			case Calendar.SUNDAY:
				startingAt = 0;
				break;
			default:
				Exception e = new Exception();
				e.printStackTrace();
				System.exit(1);
		}

		//figure out what the last day of the month is
		int last_day_in_month = currentCal.getActualMaximum(Calendar.DATE);
		//set the number on each button
		int dayNumber=1;
		for (int j=startingAt;j<MAX_BUTTONS;j++) {
			dayButton = (JButton)(dayButtons.get(j));
			dayButton.setText(Integer.toString(dayNumber));
			if (thisMonth) {
				if (dayNumber == thisMonthCal.get(Calendar.DATE))
					dayButton.setForeground(Color.red);
			} else
				dayButton.setForeground(Color.black);
			
			dayNumber++;

			if (j > last_day_in_month) break;
		}

	}

	class ButtonPressAction implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			JButton button = (JButton)(e.getSource());

			currentCal.set(Calendar.DATE, Integer.parseInt(button.getText()));
			currentCal.set(Calendar.HOUR, Integer.parseInt((String)hoursCombo.getSelectedItem())); 
			currentCal.set(Calendar.MINUTE, Integer.parseInt((String)minutesCombo.getSelectedItem()));
			String ampm = (String)(ampmCombo.getSelectedItem());
			if (ampm.equals("PM"))
				currentCal.set(Calendar.AM_PM, Calendar.PM);
			else
				currentCal.set(Calendar.AM_PM, Calendar.AM);


			//set the global date so listeners can get the selected date
			date = currentCal.getTime();
			myEditor.setDate(date);
			hide();
		}
	}


	/**
	 * set the screen's colors 
	 */
	public final void setColors() {
	}

	/**
	 * set the screen's fonts 
	 */
	public final void setFonts() {
	}

	/**
	 * set the dialog's language
	 */
	public final void setLang() {
		setTitle(wb.getLang().getString("calendarSelection"));
	}

}
