package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the table to object
 * mapping for the campaigns table shown on the
 * GUI dialog for campaign mgmt.
 */
public class CampaignTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Campaign Name", "Type", "Product Group", "Product Line", 
		"Leads Generated" };

	private ArrayList wholeList = null;
	private Campaign sample = new Campaign();

	/**
	 * construct a table using a list of Campaign objects 
	 * @param wholeList the list of Campaigns to display
	 */
	public CampaignTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
   		sample.setName("camp 1");
        sample.setType("type 1");
        sample.setProductGroup("group 1");
        sample.setProductLine("line 1");
        sample.setLeadCount(new Integer(3));
		setLang();
	}

	/**
	 * add a Campaign to the table 
	 * @param f the Campaign to add
	 */
	public final void addCampaign(Campaign f) {
		wholeList.add(f);
	}

	/**
	 * get a Campaign from the table using an index 
	 * @param index the Campaign index key
	 * @return the Campaign at that index 
	 */
	public final Campaign getCampaign(int index) {
		return (Campaign)(wholeList.get(index));
	}

	/**
	 * delete a Campaign from the table 
	 * @param index the Campaign's index 
	 */
	public final void deleteCampaign(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the list of Campaigns from this table 
	 * @return the ArrayList of Campaigns
	 */
	public final ArrayList getCampaigns() { 
		return wholeList;
	}

	/**
	 *  get a table cell value 
	 * @param row the table cell's row index
	 * @param col the table cell's column index
	 * @return the value at that cell
	 */
	public final Object getValueAt(int row, int col) {
		Campaign sample=null;
		sample = (Campaign)wholeList.get(row);
		switch (col) {
			case 0: //campaign name
				return sample.getName();
			case 1: //type
				return sample.getType();
			case 2: //group
				return sample.getProductGroup();
			case 3: //line
				return sample.getProductLine();
			case 4: //leads generated count
				return sample.getLeadCount();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 *  get the row count
	 * @return the row count
	 */
	public final int getRowCount() {
		return wholeList.size();
	}

	/**
	 * get the column count 
	 * @return the column count
	 */
	public final int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * get the column name 
	 * @param col the column index starting at 0 to get
	 * a name for
	 * @return the column name
	 */
	public final String getColumnName(int col) {
		return columnNames[col];
	}

	/**
	 * get the column's Class 
	 * @param col the index of a column
	 * @return the class name of that column
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //campaign name
				return sample.getName().getClass();
			case 1: //type
				return sample.getType().getClass();
			case 2: //product group
				return sample.getProductGroup().getClass();
			case 3: //product line
				return sample.getProductLine().getClass();
			case 4: //leads generated count
				return sample.getLeadCount().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 * set a cell's value
	 * @param value the value we are setting the cell to
	 * @param row the row index of the cell
	 * @param col the column index of the cell
	 */
	public final void setValueAt(Object value, int row, int col) {
		Campaign f = null;
		f = (Campaign)wholeList.get(row);
		switch (col) {
			case 0: //campaign name
				sample.setName((String)value);
				break;
			case 1: //type
				sample.setType((String)value);
				break;
			case 2: //product group
				sample.setProductGroup((String)value);
				break;
			case 3: //product line
				sample.setProductLine((String)value);
				break;
			case 4: //leads generated count
				sample.setLeadCount((Integer)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 *  see if a cell is editable
	 * @param row the row index
	 * @param col the column index
	 * @return true if the cell is editable
	 */
	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		return  false;
	}

	/**
	 * set the table's header text to another language
	 */
	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		
		columnNames[0] = wb.getLang().getString("campaignName");
		columnNames[1] = wb.getLang().getString("type");
		columnNames[2] = wb.getLang().getString("productGroup");
		columnNames[3] = wb.getLang().getString("productLine");
		columnNames[4] = wb.getLang().getString("leadsGenerated");

	}
}
