package sellwin.gui;

import sellwin.utils.*;
import sellwin.domain.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class ties the date editor dialog to
 * a table's date column
 */
public class DateEditor extends DefaultCellEditor implements DateEditorDialogListener {

	private DateRenderer renderer = new DateRenderer();
	private Date currentDate = null;
	private JButton editorComponent=null;
	private JTable table=null;

	/**
	 * construct the date editor 
	 * @param b the button that causes the date editor dialog to popup
	 * @param table the table that will use this trigger
	 */
	public DateEditor(JButton b, JTable table) {
		super(new JCheckBox());
		this.table = table;

		editorComponent = b;
		setClickCountToStart(1);

		b.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				fireEditingStopped();
			}
		});
	}

	/**
	 * get the date
	 * @return the current date
	 */
	public final Date getDate() {
		return currentDate;
	}


	/**
	 * set the date 
	 * @param d the date
	 */
	public final void setDate(Date d) {
		currentDate = d;
		((JButton)editorComponent).setText(Prefs.dateFormat.format(currentDate));
		TableModel model = table.getModel();
		table.tableChanged(new TableModelEvent(model));
		fireEditingStopped();
	}

	/**
	 * get the table's cell editor component
	 * @param table description
	 * @return description
	 * @exception class-name description
	 */
	public final Component getTableCellEditorComponent(
		JTable table,
		Object value,
		boolean isSelected,
		int row, int col) {

		if (value == null) value = new Date();
		Date dt  = (Date)value;
		
		((JButton)editorComponent).setText(Prefs.dateFormat.format(dt));
		currentDate = (Date)value;
		return editorComponent;
	}

	/**
	 * fire the editing stopped message
	 */
	protected final void fireEditingStopped() {
		super.fireEditingStopped();
	}

	/**
	 * get the cell editor value 
	 * @return description
	 */
	public final Object getCellEditorValue() {
		return currentDate;
	}
}
