package sellwin.gui;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the popup date-calendar
 * dialog.  It is used to edit a date value on
 * some of the screens.  It pops up when a date
 * cell or field is clicked on by the user.
 */
public class DateEditorDialog extends JDialog {


	private DatePanel datePanel = new DatePanel();
	private JButton okButton = new JButton("Ok");
	private final DateEditorDialogListener myEditor;
	

	/**
	 * construct a date editor dialog 
	 * @param owner the frame that owns this dialog
	 * @param editor the listener of this dialog that
	 * receives the date when this dialog hides itself
	 */
	public DateEditorDialog(Frame owner, DateEditorDialogListener editor) {
		super(owner, "Date Editor", true);

		myEditor= editor;
		Whiteboard wb = MainWindow.getWhiteboard();
		setTitle(wb.getLang().getString("dateEditor"));
		setFont(MainWindow.LABEL_FONT);
		setSize(440, 190);

		getContentPane().setLayout(new BorderLayout());

		setColors();
		setFonts();


		okButton.addActionListener(
          new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					myEditor.setDate(datePanel.getDate());
					hide();
                }
            });

		getContentPane().add(datePanel, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		buttonPanel.add(okButton);
		getContentPane().add(buttonPanel, BorderLayout.SOUTH);


 		WindowListener l = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
			}

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };
 
        addWindowListener(l);

		getRootPane().setDefaultButton(okButton);

	}


	/**
	 * set the date this dialog will display
	 * @param d the date we are setting with
	 */
	public final void setDate(Date d) {
		datePanel.setDate(d);
	}

	/**
	 * get the date from this dialog 
	 * @return the date this dialog knows about
	 */
	public final Date getDate() {
		return datePanel.getDate();
	}

	/**
	 * set the dialog's colors 
	 */
	private final void setColors() {
	}

	/**
	 * set the dialog's fonts 
	 */
	private final void setFonts() {
	}
}
