package sellwin.gui;

import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the date panel that is shown in
 * the date editor dialog.  Day's and month's are
 * represented by this widget.
 */
public class DatePanel extends JPanel {
 	private	String[] MONTHS =  {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun", 
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

	private JComboBox yearCombo = new JComboBox();
	private JComboBox monthCombo = new JComboBox();
	private JComboBox dayCombo = new JComboBox();

	/**
	 * construct the date panel 
	 */
	public DatePanel() {
		super();
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		setPreferredSize(new Dimension(170,22));
		setMinimumSize(new Dimension(170,22));
 		monthCombo.setModel(new javax.swing.DefaultComboBoxModel(MONTHS));
        add(monthCombo);
 		dayCombo.setModel(new javax.swing.DefaultComboBoxModel(
			new String[] { "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31" }));
        add(dayCombo);

        yearCombo.setModel(new javax.swing.DefaultComboBoxModel(
			new String[] { "2001", "2002", "2003" }));
        add(yearCombo);

		setColors();
		setFonts();
	}

	/**
	 * set the date shown by the date panel
	 * @param d the date we are to use
	 */
	public final void setDate(java.util.Date d) {
	
		if (d == null)
			d = new java.util.Date();
	
		Calendar cal = new GregorianCalendar();
		if (d != null) //use the current date & time if input is null
			cal.setTime(d);
		else
			cal.setTime(new java.util.Date());
		int yyyy = cal.get(Calendar.YEAR);
		int mm = cal.get(Calendar.MONTH);
		int dd = cal.get(Calendar.DAY_OF_MONTH);
	
		SimpleDateFormat formatter = new SimpleDateFormat("MMM");

		try {
			String month = formatter.format(d);
			yearCombo.setSelectedItem(Integer.toString(yyyy));
			dayCombo.setSelectedItem(Integer.toString(dd));
			monthCombo.setSelectedItem(month);
		} catch (NumberFormatException e) {
			ErrorHandler.show(this, e);
		}
	}

	/**
	 * get the date this panel is using
	 * @return the date
	 */
	public final java.util.Date getDate() {
		String yyyy = (String)(yearCombo.getSelectedItem());
		String dd = (String)(dayCombo.getSelectedItem());
		int mm = monthCombo.getSelectedIndex();

		try {
			int iyyyy = Integer.parseInt(yyyy);
			int idd = Integer.parseInt(dd);
			Calendar cal = new GregorianCalendar(iyyyy, mm, idd);
			return cal.getTime();
		} catch (NumberFormatException e) {
			ErrorHandler.show(this, e);
		}
		return null;
	}

	/**
	 *  set the panel's fonts
	 */
	private final void setFonts() {
		yearCombo.setFont(MainWindow.FIELD_FONT);
		monthCombo.setFont(MainWindow.FIELD_FONT);
		dayCombo.setFont(MainWindow.FIELD_FONT);
	}

	/**
	 * set this panel's colors 
	 */
	private final void setColors() {
		yearCombo.setBackground(Color.white);
		monthCombo.setBackground(Color.white);
		dayCombo.setBackground(Color.white);
	}
}
