package sellwin.gui;

import sellwin.utils.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements a description renderer for the 
 * activity table  to display a really long string in a table
 */
public class DescRenderer extends JLabel implements TableCellRenderer {

	private String currentDesc;

	/**
	 * construct a desc renderer 
	 */
	public DescRenderer() {
		super();
		setBackground(MainWindow.LETTERS);
		setFont(MainWindow.FIELD_FONT);
	}

	/**
	 * part of the java interface spec 
	 */
	public final Component getTableCellRendererComponent(
		JTable table, Object value,
		boolean isSelected, boolean hasFocus,
		int row, int col) {

		if (value == null)
			currentDesc = new String("");
		else
			currentDesc = (String)value;

		setText(currentDesc);
		return this;
	}


	/**
	 * get the desc used by this renderer 
	 * @return the desc being used
	 */
	public final String getDesc() {
		return currentDesc;
	}

	/**
	 * set the label's text using the object (desc) 
	 * @param value the object we are to render
	 */
	public final void setValue(Object value) {
		if (value == null)
			currentDesc = new String("");
		else {
			currentDesc = (String)value;
		}


		setText(currentDesc);
	}
}
