package sellwin.gui;

import sellwin.utils.*;
import javax.swing.*;
import java.awt.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class provides a simple error display handler
 * for the GUI
 */
public class ErrorHandler {

	/**
	 * show a popup error dialog
	 * @param parent the container for this popup
	 * @param g the exception to display in this popup
	 */
	public final static void show(Component parent, Exception g) {
		LogWrite.write(g);
		g.printStackTrace();
		JOptionPane.showMessageDialog(
			parent,
			g.getMessage(),
			"ERROR",
			JOptionPane.ERROR_MESSAGE);
	}

	/**
	 * show a popup error dialog
	 * @param parent the container for this popup
	 * @param g the exception to display in this popup
	 * @param str a user supplied string to display as well as the err
	 */
	public final static void show(Component parent, Exception g, String str) {
		LogWrite.write(g);
		g.printStackTrace();
		JOptionPane.showMessageDialog(
			parent,
			g.getMessage() + ":" + str,
			"ERROR",
			JOptionPane.ERROR_MESSAGE);
	}
}
