package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the funnel dialog
 */
public class FunnelDialog extends JDialog implements GUIChars {

	private Whiteboard wb;
	
	public final static String[] STAGES = { 
		Opportunity.STAGE_IDENTIFIED, 
		Opportunity.STAGE_CONTACTED, 
		Opportunity.STAGE_BIDDING,
		Opportunity.STAGE_CHANCE, 
		Opportunity.STAGE_WINNING, 
		Opportunity.STAGE_AWARDED, 
		Opportunity.STAGE_CONTRACT,
		Opportunity.STAGE_BILLED };

	private PolyPanel polys = null;
	private JButton closeButton = new JButton("Close");
	private JButton refreshButton = new JButton("Refresh");

	/**
	 * construct the funnel dialog
	 */
	public FunnelDialog() {
		super();
		wb = MainWindow.getWhiteboard();
		setTitle(wb.getLang().getString("salesFunnel"));
		setSize(640,600);
		getContentPane().setLayout(new BorderLayout());
		JPanel mainPanel = new JPanel(new BorderLayout());
		mainPanel.setBorder(new EtchedBorder());
		try {
			polys = new PolyPanel();
		} catch (AngError e) {
			ErrorHandler.show(this, e);
		}
		mainPanel.add(polys, BorderLayout.CENTER);
		polys.setSize(400,400);
		getContentPane().add(mainPanel, BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		buttonPanel.add(refreshButton);
		buttonPanel.add(closeButton);
		getContentPane().add(buttonPanel, BorderLayout.SOUTH);

        WindowListener l = new WindowAdapter() {
            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };

		addWindowListener(l);

    	refreshButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					polys.refresh();
                }
            });
    	closeButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    hide();
                }
            });

		getRootPane().setDefaultButton(closeButton);
		setLang();
		setFonts();

	}

	/**
	 *  not used
	 */
	public void refreshOpportunity() {
	}

	/**
	 * set the dialog's language
	 */
	public final void setLang() {
		closeButton.setText(wb.getLang().getString("close"));
		refreshButton.setText(wb.getLang().getString("refresh"));
		setTitle(wb.getLang().getString("salesFunnel"));
	}

	public void setColors() {}

	public void setFonts() {
        refreshButton.setFont(MainWindow.LABEL_FONT);
        closeButton.setFont(MainWindow.LABEL_FONT);
	}
}
