package sellwin.gui;

import sellwin.server.*;
import java.net.*;
import java.io.*;
import java.beans.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Help dialog that
 * shows the SellWin help text as HTML
 */
public class HelpDialog extends JDialog {

	private ServerInterface t = null;
	private Whiteboard wb=null;
	private final static int STRUT_LEN=3;
	private JPanel mainPanel = new JPanel(new BorderLayout());
	private JEditorPane html;
	private MainWindow parent = null;
	

	/**
	 * construct the help dialog 
	 * @param parent the containing frame for this dialog
	 */
	public HelpDialog(MainWindow parent) {
		super();
		this.parent = parent;
		wb = MainWindow.getWhiteboard();
		setTitle(wb.getLang().getString("help"));
		setSize(440, 190);
		getContentPane().setLayout(new BorderLayout());

		String path = "/resource/help.html";
		URL url = null;
		try {
			url = getClass().getResource(path);

			html = new JEditorPane(url);
			html.setEditable(false);
			html.addHyperlinkListener(createHyperLinkListener());
		} catch (Exception e) {
			ErrorHandler.show(parent, e);
		}
		JScrollPane scroller = new JScrollPane();
		JViewport vp = scroller.getViewport();
		vp.add(html);	
		getContentPane().add(scroller, BorderLayout.CENTER);


 		WindowListener l = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
			}

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };
 
        addWindowListener(l);
	}

	/**
	 * 
	 * @param name description
	 * @return description
	 * @exception class-name description
	 */
	public HyperlinkListener createHyperLinkListener() {
		return new HyperlinkListener() {
			public void hyperlinkUpdate(HyperlinkEvent e) {
				if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				} 
			}
		};
	}

	public void setLang() { 
		setTitle(wb.getLang().getString("help"));
	}
}
