package sellwin.gui;

import sellwin.domain.*;
import sellwin.server.BizServices;
import sellwin.utils.*;
import sellwin.server.*;

import java.rmi.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.awt.event.*;

import javax.ejb.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class is the logon dialog window that the GUI presents
 * to the user as they log onto Sellwin
 */
public class LogonDialog extends JDialog implements GUIChars {

	private static final int MAX_ATTEMPTS=5;
	private int attempts=0;
	private JDialog thisDialog;
	private Whiteboard wb;

	private JTabbedPane tabbedPane = new JTabbedPane();

	private SellwinSession server = null;
	private JPanel mainPanel = new JPanel(new BorderLayout());
	private JLabel idLabel = new JLabel("User ID:");
	private JTextField id = new JTextField();
	private JLabel passwordLabel = new JLabel("Password:");
	private JPasswordField psw = new JPasswordField();

	private PrefsPanel wholePrefsPanel = new PrefsPanel();
	private JButton prefsApplyButton = new JButton("Apply");
	private JButton prefsCloseButton = new  JButton("Close");

	private JTextField dataDir = new JTextField(40);
	private JButton logonButton = new JButton("OK");
	private JButton closeButton = new  JButton("Close");
	private MainWindow parent = null;
	
	
	/**
	 * construct a logon dialog  
	 * @param parent the containing parent container
	 */
	public LogonDialog(MainWindow parent) {
		super();

		this.parent = parent;
		thisDialog = this;
		wb = MainWindow.getWhiteboard();

		setTitle(wb.getLang().getString("userLogon"));
		setFont(MainWindow.LABEL_FONT);
		setSize(380, 300);
		getContentPane().setLayout(new BorderLayout());

		setColors();
		setFonts();

		JPanel panel1 = new JPanel();

		GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel1.setLayout(gbl);
		panel1.setBorder(new EtchedBorder());

		gbc.anchor = GridBagConstraints.WEST;
        panel1.add(idLabel, gbc);

        gbc = new GridBagConstraints();
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 1;
        panel1.add(passwordLabel, gbc);

        gbc = new GridBagConstraints();
		gbc.insets = new java.awt.Insets(2, 7, 2, 7);
		gbc.anchor = GridBagConstraints.WEST;
		id.setMinimumSize(new Dimension(80, Prefs.FIELD_HEIGHT));
		id.setMaximumSize(new Dimension(80, Prefs.FIELD_HEIGHT));
		id.setPreferredSize(new Dimension(80, Prefs.FIELD_HEIGHT));
        panel1.add(id, gbc);


        gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.insets = new java.awt.Insets(2, 7, 2, 7);
		gbc.anchor = GridBagConstraints.WEST;
		psw.setMinimumSize(new Dimension(80, Prefs.FIELD_HEIGHT));
		psw.setMaximumSize(new Dimension(80, Prefs.FIELD_HEIGHT));
		psw.setPreferredSize(new Dimension(80, Prefs.FIELD_HEIGHT));
        panel1.add(psw, gbc);

		//PREFS TAB

		JPanel prefsPanel = new JPanel(new BorderLayout());
		prefsPanel.add(wholePrefsPanel, BorderLayout.CENTER);

  		JPanel prefsbuttonPanel = new JPanel();
        prefsbuttonPanel.add(prefsApplyButton);
        prefsbuttonPanel.add(prefsCloseButton);
        prefsPanel.add(prefsbuttonPanel, BorderLayout.SOUTH);

		mainPanel.add(panel1, BorderLayout.CENTER);

		JPanel panel2 = new JPanel();
		logonButton.addActionListener(
          new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					try {
						Properties props = Prefs.getApplProps();
						
						String mode = (String)(props.getProperty(Prefs.CONN_MODE));
						if (mode.equals(Prefs.LOCAL)) {
							String db = (String)(props.getProperty(Prefs.LOCAL_DB));
							String id = (String)(props.getProperty(Prefs.LOCAL_DB_ID));
							String psw = (String)(props.getProperty(Prefs.LOCAL_DB_PSW));
							SellwinSession biz = new BizServices(Prefs.MYSQL);
							((BizServices)biz).init2Tier("jdbc:mysql:///"+ db, id, psw);
							server = biz;

							examineTables(biz);

							
						} else { //RMI
							String serverName = (String)(props.getProperty(Prefs.SERVER_NAME));
							String port = "1099";
							LogWrite.write("connecting to server at " + serverName + " port " + port);
					
							InitialContext ic = Utility.getEJBContext(serverName, port);
							SellwinSessionHome sellwinHome = (SellwinSessionHome) ic.lookup("SellWinSessionBean");		
							server = sellwinHome.create(); //("rmi://"+serverName+"/RMIBizServices");
						}
						char[] temp = psw.getPassword();
						if (server == null)
							LogWrite.write("server is null");
						LogWrite.write("cred = " + id.getText() + "-" + temp);
						Login login = server.logon(id.getText(), new String(temp));
						wb.setCurrentLogin(login);

						MainWindow.setSecurity(wb.getLogin());
						
						wb.setRemIF(server);
						wb.setLoggedOn(true);
						MainWindow.setLogonOff();
						MainWindow.getOppPanel().load();
						MainWindow.getOppList().loadUser();
						MainWindow.getOppList().setLocation(MainWindow.calcLocation());
						MainWindow.getOppList().show();
						MainWindow.setItemsOn();
						hide();
						props = Prefs.getApplProps();	
						props.setProperty(Prefs.LAST_ID, id.getText());	
						Prefs.saveApplProps(props);
						attempts=0;
					} catch (Exception g) {
						ErrorHandler.show(thisDialog, g);
						attempts++;
						if (attempts >= MAX_ATTEMPTS) {
							hide();
							ErrorHandler.show(thisDialog, new AngError("Log-in unsuccessful, please see System Administrator."));
						} else {
							ErrorHandler.show(thisDialog, g);
						}
					}
                }
            });

		closeButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					hide();
				}
			});
		panel2.add(logonButton);
		panel2.add(closeButton);

		mainPanel.add(panel2, BorderLayout.SOUTH);

		tabbedPane.add(wb.getLang().getString("logon"), mainPanel);
		tabbedPane.add(wb.getLang().getString("prefs"), prefsPanel);

		getContentPane().add(tabbedPane, BorderLayout.CENTER);


 		WindowListener l = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
			}

            public void windowClosing(WindowEvent e) {
                hide();
            }
        };
 
        addWindowListener(l);

		getRootPane().setDefaultButton(logonButton);

		wholePrefsPanel.getProps();
  
		prefsCloseButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    hide();
                }
            });

        prefsApplyButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    wholePrefsPanel.storeProps();
                }
            });

		setLang();
	}


	/**
	 * get the remote server interface 
	 * @return the 
	 */
	public final SellwinSession getRemInterface() {
		return server;
	}

	/**
	 * request focus to the password field 
	 */
	public final void requestFocus() {
		psw.requestFocus();
	}

	/**
	 * set the initial user from the user's
	 * properties file
	 */
	public final void setInitialUser() {
		String userName = Prefs.getLastID();
		if ((userName != null) || (userName.length() > 0))
			id.setText(userName);
	}

	/**
	 * set the screen's colors 
	 */
	public final void setColors() {
		idLabel.setForeground(Color.black);
		passwordLabel.setForeground(Color.black);
	}

	/**
	 * set the screen's fonts 
	 */
	public final void setFonts() {
		idLabel.setFont(MainWindow.LABEL_FONT);
		id.setFont(MainWindow.FIELD_FONT);
		passwordLabel.setFont(MainWindow.LABEL_FONT);
		psw.setFont(MainWindow.FIELD_FONT);
		prefsApplyButton.setFont(MainWindow.LABEL_FONT);
		prefsCloseButton.setFont(MainWindow.LABEL_FONT);
		dataDir.setFont(MainWindow.FIELD_FONT);
		tabbedPane.setFont(MainWindow.LABEL_FONT);
		logonButton.setFont(MainWindow.LABEL_FONT);
		closeButton.setFont(MainWindow.LABEL_FONT);
	}

	class RadioListener implements ActionListener {
		public RadioListener() {
			super();
		}

	/**
	 * handle preference changes by the user 
	 */
		public void actionPerformed(ActionEvent e) {
			if (e.getActionCommand().equals(Prefs.CONNECTED))
				wb.setSpeed(Prefs.CONNECTED);	
			else
				wb.setSpeed(Prefs.LOCAL);	
		}
	}

	/**
	 * set the dialog's language
	 */
	public final void setLang() {
		setTitle(wb.getLang().getString("userLogon"));
		prefsApplyButton.setText(wb.getLang().getString("apply"));
		prefsCloseButton.setText(wb.getLang().getString("close"));
		logonButton.setText(wb.getLang().getString("ok"));
		closeButton.setText(wb.getLang().getString("close"));
		tabbedPane.setTitleAt(0, wb.getLang().getString("logon"));
		tabbedPane.setTitleAt(1, wb.getLang().getString("prefs"));
		idLabel.setText(wb.getLang().getString("userid"));
		passwordLabel.setText(wb.getLang().getString("password"));
	}

	private void examineTables(SellwinSession biz) {
		try {
							if (((BizServices)biz).testTable())
								LogWrite.write("local database exists");
							else {
								LogWrite.write("local database about to be created");
								((BizServices)biz).createAllTables();
								LogWrite.write("local database has been created");
							}

							int rc = ((BizServices)biz).testTableData();
							System.out.println("rc test Table data returned " + rc);
	
							if (rc < 1) {
								LogWrite.write("loading test data");
								((BizServices)biz).loadTestData();
								LogWrite.write("test data load complete");
							} else 
								LogWrite.write("test data already loaded");

		} catch (Exception e) {
			LogWrite.write(e);
		}
	}
}
