package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class is the order detail table model
 * see the java spec for a full explaination of
 * this framework
//just like QuoteLineTableModel except we don't want to show
//the cost on the Order
 */
public class OrderDetailTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Product Name", "Qty", "Model No.", "Price",
		"Description" };

	private ArrayList wholeList = null;
	private QuoteLine line = new QuoteLine();

	/**
	 * construct an order detail table model
	 * @param wholeList the list of Orders to load
	 */
	public OrderDetailTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		line.setProduct(new Product());
		line.getProduct().setName("hi");
		line.setQuantity(new Integer(10));
		line.getProduct().setModelNo("1234");
		line.getProduct().setPrice(new Double(10.88));
		line.getProduct().setDesc("desc");
	
		setLang();
	}

	/**
	 * add a quote line   to the model
	 * @param f QuoteLine to add to the list
	 */
	public void addQuoteLine(QuoteLine f) {
		wholeList.add(f);
	}

	/**
	 * get a specific QuoteLine from the list
	 * @param index the index to use
	 * @return the QuoteLine 
	 */
	public final QuoteLine getQuoteLine(int index) {
		return (QuoteLine)(wholeList.get(index));
	}

	/**
	 * delete a QuoteLine from the model's list 
	 * @param index the QuoteLine to delete
	 */
	public final void deleteQuoteLine(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the whole list of order details 
	 * @return the list
	 */
	public final ArrayList getOrderDetails() { 
		return wholeList;
	}

	/**
	 * see the java spec 
	 */
	public final Object getValueAt(int row, int col) {
		QuoteLine line=null;
		line = (QuoteLine)wholeList.get(row);
		switch (col) {
			case 0: //product name
				return line.getProduct().getName();
			case 1: //quantity
				return line.getQuantity();
			case 2: //model number
				return line.getProduct().getModelNo();
			case 3: //price
				return line.getProduct().getPrice();
			case 4: //description
				return line.getProduct().getDesc();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 * see the java spec
	 */
	public final int getRowQuantity() {
		return wholeList.size();
	}

	/**
	 * see the java spec 
	 */
	public final int getColumnQuantity() {
		return columnNames.length;
	}


	/**
	 * see the java spec 
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //product name
				return line.getProduct().getName().getClass();
			case 1: //quantity
				return line.getQuantity().getClass();
			case 2: //model number
				return line.getProduct().getModelNo().getClass();
			case 3: //price
				return line.getProduct().getPrice().getClass();
			case 4: //description
				return line.getProduct().getDesc().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 *  see the java spec
	 */
	public final void setValueAt(Object value, int row, int col) {
		QuoteLine line = null;
		line = (QuoteLine)wholeList.get(row);
		switch (col) {
			case 0: //product name
				line.getProduct().setName((String)value);
				break;
			case 1: //quantity
				line.setQuantity((Integer)value);
				break;
			case 2: //model number
				line.getProduct().setModelNo((String)value);
				break;
			case 3: //price
				line.getProduct().setPrice((Double)value);
				break;
			case 4: //description
				line.getProduct().setDesc((String)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 *  see the java spec
	 */
	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		return  false;
	}

	/**
	 * see the java spec 
	 */
 	public final int getColumnCount() {
        return columnNames.length;
    }

	/**
	 * see the java spec 
	 */
    public final String getColumnName(int col) {
        return columnNames[col];
    }

	/**
	 * see the java spec 
	 */
  	public final int getRowCount() {
        return wholeList.size();
    }

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames[0] = wb.getLang().getString("productName");
		columnNames[1] = wb.getLang().getString("qty");
		columnNames[2] = wb.getLang().getString("model");
		columnNames[3] = wb.getLang().getString("price");
		columnNames[4] = wb.getLang().getString("description");
	}
}
