package sellwin.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.math.*;
import java.text.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.border.*;

import sellwin.domain.*;
import sellwin.utils.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the Order Fulfillment panel
 * that a users sees when they press the 'Order' tab
 * from the MainWindow GUI
 */
public class OrderFulfillPanel extends javax.swing.JPanel {

	private final static int TABLE_WIDTH = 560;
	private final static int TABLE_HEIGHT = 100;

	private JComboBox statusCombo = new JComboBox(Order.STATUS);

	private Order currentOrder;
	private double shippingHandling=0.00;
	private static final int LABEL_WIDTH = 200;
    private OrderFulfillPanel thisPanel = null;
	private Whiteboard wb=null;
	private OrderDetailTableModel detailsModel = null;
	private OrderTableModel orderModel = null;

	private JPanel bottomPanel;
    private JPanel pmtPanel;
    private JPanel subTotalPanel;
    private JPanel shipPanel;
    private JPanel taxPanel;
    private JPanel totalPanel;

    private JPanel buttonPanel;
    private JButton applyButton;

    private JScrollPane mainScrollPane;
    private JPanel mainPanel;
	private JTabbedPane tabbedPane = new JTabbedPane();
    private AddressPanel billAddrPanel;
    private AddressPanel shipAddrPanel;

    private JComboBox paymentTypeCombo;

	private JPanel detailsPanel = new JPanel();
    private JScrollPane orderDetailsScrollPane;
    private JTable orderDetailsTable;
    private JLabel paymentTypeLabel;
    private JTextField paymentField;
    private JLabel subTotalLabel;
    private JTextField subTotalField;
    private JLabel shipLabel;
    private JTextField shipField;
    private JLabel totalLabel;
    private JTextField totalField;
    private JLabel taxLabel;
    private JTextField taxField;

	private JPanel ordersPanel;
    private JScrollPane ordersScrollPane;
    private JTable orderTable;


	/**
	 * construct an order fullfillment panel 
	 */
    public OrderFulfillPanel() {
		wb = MainWindow.getWhiteboard();
        initComponents();
		setColors();
		setFonts();

		setOrderDetails(new ArrayList());


		thisPanel = this;

		orderTable.setDefaultRenderer(Date.class, new DateRenderer());
		orderTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		orderTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		orderTable.getSelectionModel().addListSelectionListener(
			new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					if (e.getValueIsAdjusting()) return; //ignore these

					ListSelectionModel lsm = (ListSelectionModel)e.getSource();
	
					if (!lsm.isSelectionEmpty()) {
                        Order order = orderModel.getOrder(orderTable.getSelectedRow());
                        setOrder(order);
					}
				}
			}
		);
					
		applyButton.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel m = orderTable.getSelectionModel();
                    if (m.getLeadSelectionIndex() >= 0) {
                        Order o = orderModel.getOrder(m.getLeadSelectionIndex());
						o.setPaymentForm((String)(paymentTypeCombo.getSelectedItem()));	
						o.setShipAddress(shipAddrPanel.getAddress());
						o.setBillAddress(billAddrPanel.getAddress());
                        //o.setSubmitDate(new java.util.Date());
						o.setSubTotal(Double.parseDouble(subTotalField.getText()));
						o.setTax(Double.parseDouble(taxField.getText()));
						o.setShipping(Double.parseDouble(shipField.getText()));
						o.setTotal(Double.parseDouble(totalField.getText()));
                        orderTable.tableChanged(new TableModelEvent(orderModel));
						try {
							wb.updateOrder(o);
							JOptionPane.showMessageDialog(
                                thisPanel,
                                "Update Successful",
                                "Update Successful",
                                JOptionPane.INFORMATION_MESSAGE);
						} catch (AngError f) {
							ErrorHandler.show(thisPanel, f);
						}
                    }
                }
            }
        );

		shipField.addFocusListener(
			new FocusListener() {
				public void focusGained(FocusEvent e) { }
				public void focusLost(FocusEvent e) {
					computeTotal();
				}
			}
		);

		statusCombo.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
                    ListSelectionModel m = orderTable.getSelectionModel();
                    if (m.getLeadSelectionIndex() >= 0) {
                        Order row = orderModel.getOrder(m.getLeadSelectionIndex());
                        row.setStatus((String)statusCombo.getSelectedItem());
                    }
                }
            }
        );

		orderModel = new OrderTableModel(new ArrayList());
		orderTable.setModel(orderModel);
		setLang();
    }


	/**
	 * initialize the panel's components 
	 */
    private final void initComponents() {
        buttonPanel = new JPanel();
        applyButton = new JButton();
        mainScrollPane = new JScrollPane();
        mainPanel = new JPanel();
        billAddrPanel = new AddressPanel();
		//billAddrPanel.setBorder(new TitledBorder("Bill-To Address"));
        shipAddrPanel = new AddressPanel();
		//shipAddrPanel.setBorder(new TitledBorder("Ship-To Address"));
        paymentTypeCombo = new JComboBox();
        subTotalField = new JTextField("0");
		subTotalField.setEditable(false);
		subTotalField.setEnabled(false);
        taxField = new JTextField("0");
		taxField.setEditable(false);
		taxField.setEnabled(false);
        shipField = new JTextField("0.00");
        totalField = new JTextField();
		totalField.setEditable(false);
		totalField.setEnabled(false);
        orderDetailsScrollPane = new JScrollPane();
        orderDetailsTable = new JTable();
        paymentTypeLabel = new JLabel();
        taxLabel = new JLabel();
        shipLabel = new JLabel();
        totalLabel = new JLabel();
        subTotalLabel = new JLabel();
        ordersScrollPane = new JScrollPane();
        orderTable = new JTable();
        
        setLayout(new java.awt.BorderLayout());
        
        applyButton.setText("Apply");
        buttonPanel.add(applyButton);
        
        add(buttonPanel, java.awt.BorderLayout.SOUTH);

		pmtPanel = new JPanel();
		pmtPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		totalPanel = new JPanel();
		totalPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		subTotalPanel = new JPanel();
		subTotalPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		taxPanel = new JPanel();
		taxPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		shipPanel = new JPanel();
		shipPanel.setLayout(new FlowLayout(FlowLayout.LEFT));

		bottomPanel = new JPanel();
		BoxLayout lay = new BoxLayout(bottomPanel, BoxLayout.Y_AXIS);
		bottomPanel.setLayout(lay);
		bottomPanel.add(pmtPanel);
		bottomPanel.add(subTotalPanel);
		bottomPanel.add(taxPanel);
		bottomPanel.add(shipPanel);
		bottomPanel.add(totalPanel);
        
        //mainScrollPane.setBorder(new javax.swing.border.EtchedBorder());
        mainScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        mainScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
      
		tabbedPane.add(wb.getLang().getString("billAddress"), billAddrPanel); 
		tabbedPane.add(wb.getLang().getString("shipAddress"), shipAddrPanel); 
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        //mainPanel.add(billAddrPanel, gridBagConstraints1);
        mainPanel.add(tabbedPane, gridBagConstraints1);
        
        java.awt.GridBagConstraints gridBagConstraints3;
        
        //gridBagConstraints1 = new java.awt.GridBagConstraints();
        //gridBagConstraints1.gridx = 0;
        //gridBagConstraints1.gridy = 6;
        //gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        //mainPanel.add(shipAddrPanel, gridBagConstraints1);
       
        paymentTypeCombo.setModel(
			new DefaultComboBoxModel(Order.METHODS));
       
		//orderDetailsScrollPane.setBorder(new TitledBorder("Order Details")); 
        orderDetailsScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        orderDetailsScrollPane.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        orderDetailsScrollPane.setViewportView(orderDetailsTable);
		orderDetailsScrollPane.setPreferredSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
		orderDetailsScrollPane.setMaximumSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
		orderDetailsScrollPane.setMinimumSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.ipadx = 9;
        gridBagConstraints1.ipady = 9;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		detailsPanel.add(orderDetailsScrollPane);

        mainPanel.add(detailsPanel, gridBagConstraints1);
       
        paymentTypeLabel.setText("Form of Payment");
		paymentTypeLabel.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		paymentTypeLabel.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		paymentTypeLabel.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
        paymentTypeLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		pmtPanel.add(paymentTypeLabel); 
		pmtPanel.add(paymentTypeCombo); 

        subTotalLabel.setText("sub total");
		subTotalLabel.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		subTotalLabel.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		subTotalLabel.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
        subTotalLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		subTotalPanel.add(subTotalLabel); 
		subTotalField.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		subTotalField.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		subTotalField.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		subTotalPanel.add(subTotalField); 

        taxLabel.setText("Tax");
		taxLabel.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		taxLabel.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		taxLabel.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
        taxLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		taxPanel.add(taxLabel); 
		taxField.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		taxField.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		taxField.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		taxPanel.add(taxField); 

        shipLabel.setText("Shipping/Handling");
		shipLabel.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		shipLabel.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		shipLabel.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
        shipLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		shipPanel.add(shipLabel); 
		shipField.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		shipField.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		shipField.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		shipPanel.add(shipField); 

        totalLabel.setText("Total");
		totalLabel.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		totalLabel.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		totalLabel.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
        totalLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
		totalPanel.add(totalLabel); 
		totalField.setMinimumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		totalField.setMaximumSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		totalField.setPreferredSize(new Dimension(LABEL_WIDTH, Prefs.FIELD_HEIGHT));
		totalPanel.add(totalField); 
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        mainPanel.add(bottomPanel, gridBagConstraints1);
      
		ordersPanel = new JPanel();
		ordersPanel.setBorder(new TitledBorder("Orders"));
 
		//ordersScrollPane.setBorder(new TitledBorder("Orders")); 
        ordersScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        ordersScrollPane.setViewportView(orderTable);
		ordersScrollPane.setPreferredSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
		ordersScrollPane.setMaximumSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
		ordersScrollPane.setMinimumSize(new Dimension(TABLE_WIDTH,TABLE_HEIGHT));
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 2;
        //gridBagConstraints1.ipadx = 9;
        //gridBagConstraints1.ipady = 9;
        gridBagConstraints1.insets = new Insets(Prefs.I_TOP,Prefs.I_LF,Prefs.I_BOTT,Prefs.I_RT);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		ordersPanel.add(ordersScrollPane);
        //mainPanel.add(ordersScrollPane, gridBagConstraints1);
        mainPanel.add(ordersPanel, gridBagConstraints1);
        
        mainScrollPane.setViewportView(mainPanel);
        
        add(mainScrollPane, java.awt.BorderLayout.CENTER);
    }

   private final void setFonts() {
		tabbedPane.setFont(MainWindow.LABEL_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
		taxLabel.setFont(MainWindow.LABEL_FONT);
		shipLabel.setFont(MainWindow.LABEL_FONT);
		subTotalLabel.setFont(MainWindow.LABEL_FONT);
		totalLabel.setFont(MainWindow.LABEL_FONT);
		taxField.setFont(MainWindow.FIELD_FONT);
		shipField.setFont(MainWindow.FIELD_FONT);
		totalField.setFont(MainWindow.FIELD_FONT);
		subTotalField.setFont(MainWindow.FIELD_FONT);
        paymentTypeCombo.setFont(MainWindow.FIELD_FONT);
        orderDetailsTable.setFont(MainWindow.FIELD_FONT);
        paymentTypeLabel.setFont(MainWindow.LABEL_FONT);
    }

	/**
	 * set the panel's colors
	 */
    private final void setColors() {
    	paymentTypeCombo.setBackground(Color.white);
        paymentTypeLabel.setForeground(MainWindow.LETTERS);
		shipLabel.setForeground(MainWindow.LETTERS);
		taxLabel.setForeground(MainWindow.LETTERS);
		totalLabel.setForeground(MainWindow.LETTERS);
		subTotalLabel.setForeground(MainWindow.LETTERS);
    }

	/**
	 * set the panel to show the current opportunity
	 * data
	 */
	public final void refreshOpportunity() {
		Opportunity opp = wb.getCurrentOpportunity();
		ArrayList orders = opp.getOrders();


		if (orders != null) {	
			orderModel = new OrderTableModel(orders);
			orderTable.setModel(orderModel);

			ArrayList orderDetails = null;
			if (orders.size() > 0) {
				orderTable.setRowSelectionInterval(0,0);
				Order order = (Order)(orders.get(0));
				setOrder(order);
				orderDetails = order.getQuote().getLines();
			} else {
				setOrderDetails(new ArrayList());
			}

			orderDetailsTable.setDefaultRenderer(Double.class, new MoneyRenderer());
			initTableColumns();
		}
	}

	/**
	 * se the panel to a specific Order 
	 * @param o the Order to show
	 */
	public final void setSelectedOrder(Order o) {
		Opportunity opp = wb.getCurrentOpportunity();
		ArrayList orders = opp.getOrders();

		//select the order in the order table
		Order order;
		for (int i=0;i < orders.size();i++) {
			order = (Order)(orders.get(i));
			if (order.getPK() == o.getPK()) {
				orderTable.setRowSelectionInterval(i, i);
			}
		}
		
	}

	/**
	 * set the current Order  
	 * @param o the Order to set with
	 */
	private final void setOrder(Order o) {
		try {
			currentOrder = o;
			setOrderAddresses(o);
			setOrderDetails(o.getQuote().getLines());	
			paymentTypeCombo.setSelectedItem(o.getPaymentForm());
			computeTotal();
		} catch (NullPointerException  e) {
			ErrorHandler.show(thisPanel, e);
		}
	}

	/**
	 * compute and set the total field
	 */
	 private final void computeTotal() {
		double subTotal = currentOrder.getQuote().calcSubTotal();
		//subTotalField.setText(Double.toString(subTotal));
		subTotalField.setText(Prefs.money.format(subTotal));
		double salesTax = calculateSalesTax(currentOrder);
		DecimalFormat format = new DecimalFormat("0.00");
	 	taxField.setText(format.format(salesTax));
		double shippingHandling = Double.parseDouble(shipField.getText());
		double total = salesTax + subTotal + shippingHandling;
		totalField.setText(format.format(total));
	 }

	/**
	 * set the order addresses 
	 * @param order the order to show
	 */
	private final void setOrderAddresses(Order order) {
		Address shipAddress = order.getShipAddress();
		Address billAddress = order.getBillAddress();
		if (billAddress != null)
    		billAddrPanel.setAddress(billAddress);
		if (shipAddress != null)
    		shipAddrPanel.setAddress(shipAddress);
	}

	/**
	 * set the order details 
	 * @param quoteLines the QuoteLines to show
	 */
	private final void setOrderDetails(ArrayList quoteLines) {
		detailsModel = new OrderDetailTableModel(quoteLines);
    	orderDetailsTable.setModel(detailsModel);
	}

	/**
	 * clear the screen components 
	 */
	public final void clearOpportunity() {
		ArrayList orders = new ArrayList();
		orderModel = new OrderTableModel(orders);
		orderTable.setModel(orderModel);
		setOrderDetails(new ArrayList());
		initTableColumns();	
	}

	/**
	 * set the panel's language 
	 */
	public final void setLang() {
        applyButton.setText(wb.getLang().getString("apply"));
        paymentTypeLabel.setText(wb.getLang().getString("paymentForm"));
        subTotalLabel.setText(wb.getLang().getString("subtotal"));
        shipLabel.setText(wb.getLang().getString("shipHandling"));
        taxLabel.setText(wb.getLang().getString("tax"));
        totalLabel.setText(wb.getLang().getString("total"));
		ordersPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("orders"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		); 
		detailsPanel.setBorder(
			new TitledBorder(
				null,
				wb.getLang().getString("orderDetails"),
				TitledBorder.DEFAULT_JUSTIFICATION,
				TitledBorder.DEFAULT_POSITION,
				MainWindow.LABEL_FONT,
				MainWindow.LETTERS
			)
		); 

		tabbedPane.setTitleAt(0, wb.getLang().getString("billAddress"));
		tabbedPane.setTitleAt(1, wb.getLang().getString("shipAddress"));

		detailsModel.setLang();
		orderModel.setLang();
	}

	/**
	 * calculate the sales tax for an order
	 * @param order the Order we are to calculate with
	 * @return the sales tax amount
	 */
	 private final double calculateSalesTax(Order order) {
	 	ArrayList taxes=null;
		double rate=0.00;

	 	try {
	 		taxes = wb.getStateTax(false);
		} catch (AngError e) {
			ErrorHandler.show(thisPanel, e);
			return rate;
		}

		StateTax tax;

		String stateCode = order.getShipAddress().getState();

		for (int i=0;i<taxes.size();i++) {
			tax = (StateTax)taxes.get(i);
			if (tax.getCode().equals(stateCode)) {
				rate = tax.getRate();
				//System.out.println("found rate of " + rate);
				break;
			}
		}

		double subTotal = order.getQuote().calcSubTotal();
		double totalTax = rate * subTotal;
		BigDecimal uno = new BigDecimal(1.0);
		BigDecimal tt = new BigDecimal(totalTax);
		BigDecimal ttt = tt.divide(uno, 2, BigDecimal.ROUND_UP);
		return ttt.doubleValue();
	 }

	/**
	 * set the order and order details columns properties
	 */
	private final void initTableColumns() {

		//set up the order table column widths

		TableColumn col = orderTable.getColumnModel().getColumn(0); //order number
		col.setPreferredWidth(120);	

		//set up the order status combo box column
		col = orderTable.getColumnModel().getColumn(1); //status
		col.setPreferredWidth(120);	
        col.setCellEditor(new DefaultCellEditor(statusCombo));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        col.setCellRenderer(renderer);

		col = orderTable.getColumnModel().getColumn(2); //quote name
		col.setPreferredWidth(140);	

		col = orderTable.getColumnModel().getColumn(4); //created by
		col.setPreferredWidth(120);	

		//set the order details column width defaults

		col = orderDetailsTable.getColumnModel().getColumn(0); //prodname
		col.setPreferredWidth(120);	
		col = orderDetailsTable.getColumnModel().getColumn(1); //qty
		col.setPreferredWidth(40);	
		col = orderDetailsTable.getColumnModel().getColumn(2); //model
		col.setPreferredWidth(100);	
		col = orderDetailsTable.getColumnModel().getColumn(3); //price
		col.setPreferredWidth(80);	
		col = orderDetailsTable.getColumnModel().getColumn(4); //desc
		col.setPreferredWidth(120);	
	}
}
