package sellwin.gui;

import sellwin.domain.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the order table model
 * shown on the Order panel...see the java spec
 * for details on Swing tables and how models are
 * used
 */
public class OrderTableModel extends AbstractTableModel {
	private static java.util.Date tempDt = new java.util.Date();
	private String[] columnNames = {
		"OrderNumber", "Status", "Quote Name", "Created On", "Created By" };

	private ArrayList wholeList = null;
	private Order order = new Order();

	/**
	 * construct the model using a list of ORders
	 * @param wholeList the data to use for this model
	 */
	public OrderTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		order.setOrderNumber(new Long(1));
		Quote temp = new Quote();
		temp.setName("hi");
		order.setQuote(temp);
		order.setModifiedDate(new java.util.Date());
		order.setModifiedBy("bob");
		
		setLang();
	}

	/**
	 * add an ORder to the table model 
	 * @param f order to add
	 */
	public final void addOrder(Order f) {
		wholeList.add(f);
	}

	/**
	 * get an Order from this model's list of Orders 
	 * @param index the index of the Order
	 * @return the Order
	 */
	public final Order getOrder(int index) {
		return (Order)(wholeList.get(index));
	}

	/**
	 * delete an Order from the model's list 
	 * @param index the index of the Order to delete
	 */
	public final void deleteOrder(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the list of Orders  
	 * @return the list of Orders 
	 */
	public final ArrayList getOrders() { 
		return wholeList;
	}

	/**
	 * see the java spec 
	 */
	public final Object getValueAt(int row, int col) {
		Order order=null;
		order = (Order)wholeList.get(row);
		switch (col) {
			case 0: //order number
				return order.getOrderNumber();
			case 1: //status 
				return order.getStatus();
			case 2: //quote name
				return order.getQuote().getName();
			case 3: //created date
				return order.getModifiedDate();
			case 4: //creator 
				return order.getModifiedBy();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 * see the java spec
	 */
	public final int getRowCount() {
		return wholeList.size();
	}

	/**
	 * see the java spec 
	 */
	public final int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * see the java spec 
	 */
	public final String getColumnName(int col) {
		return columnNames[col];
	}

	/**
	 * see the java spec 
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //order number
				return order.getOrderNumber().getClass();
			case 1: //status
				return order.getStatus().getClass();
			case 2: //order name
				return order.getQuote().getName().getClass();
			case 3: //created Date
				return order.getModifiedDate().getClass();
			case 4: //creator
				return order.getModifiedBy().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 * see the java spec 
	 */
	public final void setValueAt(Object value, int row, int col) {
		Order f = null;
		f = (Order)wholeList.get(row);
		switch (col) {
			case 0: //order number
				order.setOrderNumber((Long)value);
				break;
			case 1: //status
				System.out.println("setting status to " + value);
				order.setStatus((String)value);
				break;
			case 2: //order name
				order.getQuote().setName((String)value);
				break;
			case 3: //created date
				order.setModifiedDate((java.util.Date)value);
				break;
			case 4: //creator
				order.setModifiedBy((String)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 *  see the java spec
	 * set NO edit
	 */
	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		if (col == 1) return true;
		return  false;
	}

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();

		columnNames[0] = wb.getLang().getString("orderNumber"); 
		columnNames[1] = wb.getLang().getString("status"); 
		columnNames[2] = wb.getLang().getString("quoteName"); 
		columnNames[3] = wb.getLang().getString("createdDate"); 
		columnNames[4] = wb.getLang().getString("createdBy");
	}
}
