package sellwin.gui;

import sellwin.domain.*;
import sellwin.utils.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import java.util.*;
import java.text.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements a table model for the quotes table
 * see the java spec for swing tables for details on thich
 * mechanism
 */
public class QuoteTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Quote Name", "Created On", "Created By" };

	private ArrayList wholeList = null;
	private Quote quote = new Quote();

	/**
	 * construct a quote table model 
	 * @param wholeList a list of quotes to load this model
	 * with
	 */
	public QuoteTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		quote.setName("hi");
		quote.setModifiedBy("bob");

		setLang();
	}

	/**
	 * add a Quote to the list this table model uses 
	 * @param f Quote to add to this model's list
	 */
	public final void addQuote(Quote f) {
		wholeList.add(f);
	}

	/**
	 * get a Quote from this model's list 
	 * @param index use this index to retreive a Quote
	 * from the list used by this model
	 * @return a Quote
	 */
	public final Quote getQuote(int index) {
		return (Quote)(wholeList.get(index));
	}

	/**
	 * delete a Quote from the list 
	 * @param index the index to perform the lookup with
	 */
	public final void deleteQuote(int index) {
		wholeList.remove(index);
	}

	/**
	 * get the whole list of Quotes used by this model 
	 * @return the list of Quotes
	 */
	public final ArrayList getQuotes() { 
		return wholeList;
	}

	/**
	 * see the java spec 
	 */
	public final Object getValueAt(int row, int col) {
		Quote quote=null;
		quote = (Quote)wholeList.get(row);
		switch (col) {
			case 0: //quote name
				return quote.getName();
			case 1: //created date
				return quote.getModifiedDate();
			case 2: //creator 
				return quote.getModifiedBy();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 * see the java spec 
	 */
	public final int getRowCount() {
		return wholeList.size();
	}

	/**
	 * see the java spec 
	 */
	public final int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * see the java spec 
	 */
	public final String getColumnName(int col) {
		return columnNames[col];
	}

	/**
	 * see the java spec 
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //quote name
				return quote.getName().getClass();
			case 1: //created Date
				return quote.getModifiedDate().getClass();
			case 2: //creator
				return quote.getModifiedBy().getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 * see the java spec 
	 */
	public final void setValueAt(Object value, int row, int col) {
		Quote f = null;
		f = (Quote)wholeList.get(row);
		switch (col) {
			case 0: //quote name
				quote.setName((String)value);
				break;
			case 1: //created date
				quote.setModifiedDate((java.util.Date)value);
				break;
			case 2: //creator
				quote.setModifiedBy((String)value);
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 * see the java spec
	 */
	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);

		return  false;
	}

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames[0] = wb.getLang().getString("quoteName");
		columnNames[1] = wb.getLang().getString("createdDate");
		columnNames[2] = wb.getLang().getString("createdBy");
	}
}
