package sellwin.gui;

import sellwin.domain.*;
import sellwin.server.*;
import sellwin.utils.*;

import java.util.*;
import java.rmi.*;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements a table model for the stats table
 * see the java spec for swing tables for details on thich
 * mechanism
 */
public class StatTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"Data Type", "Sync Status", "Local Inserts", "Local Updates" };

	private ArrayList wholeList = null;
	private Stat stat = new Stat();

	/**
	 * construct a stat table model 
	 * @param wholeList a list of stats to load this model
	 * with
	 */
	public StatTableModel(ArrayList wholeList) {
		this.wholeList = wholeList;
		stat.dataType = "init";
		stat.syncStatus = "Ready";
		stat.localInserts = new Integer(0);
		stat.localUpdates = new Integer(0);

		setLang();
	}

	/**
	 * add a Stat to the list this table model uses 
	 * @param f Stat to add to this model's list
	 */
	public final void addStat(Stat f) {
		wholeList.add(f);
	}

	/**
	 * get a Stat from this model's list 
	 * @param index use this index to retreive a Stat
	 * from the list used by this model
	 * @return a Stat
	 */
	public final Stat getStat(int index) {
		return (Stat)(wholeList.get(index));
	}

	/**
	 * get the whole list of Stats used by this model 
	 * @return the list of Stats
	 */
	public final ArrayList getStats() { 
		return wholeList;
	}

	/**
	 * see the java spec 
	 */
	public final Object getValueAt(int row, int col) {
		Stat stat = (Stat)wholeList.get(row);
		switch (col) {
			case 0: //Stat dataType
				return stat.dataType;
			case 1: //Stat syncStatus
				return stat.syncStatus;
			case 2: //local inserts 
				return stat.localInserts;
			case 3: //local updates 
				return stat.localUpdates;
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;	
	}

	/**
	 * see the java spec 
	 */
	public final int getRowCount() {
		return wholeList.size();
	}

	/**
	 * see the java spec 
	 */
	public final int getColumnCount() {
		return columnNames.length;
	}

	/**
	 * see the java spec 
	 */
	public final String getColumnName(int col) {
		return columnNames[col];
	}

	/**
	 * see the java spec 
	 */
	public final Class getColumnClass(int col) {
		switch (col) {
			case 0: //dataType
				return stat.dataType.getClass();
			case 1: //syncStatus
				return stat.syncStatus.getClass();
			case 2: //local inserts
				return stat.localInserts.getClass();
			case 3: //local updates
				return stat.localUpdates.getClass();
			default:
				System.out.println("oops its dorked");
			break;
		}
		return null;
	}	
	
	/**
	 * see the java spec 
	 */
	public final void setValueAt(Object value, int row, int col) {
		Stat f = (Stat)wholeList.get(row);
		switch (col) {
			case 0: //dataType
				stat.dataType = (String)value;
				break;
			case 1: //syncStatus
				stat.syncStatus = (String)value;
				break;
			case 2: //localInserts
				stat.localInserts = (Integer)value;
				break;
			case 3: //localUpdates
				stat.localUpdates= (Integer)value;
				break;
			default:
				System.out.println("oops its dorked");
			break;
		}
		fireTableCellUpdated(row, col);
	}

	/**
	 * see the java spec
	 */
	public final boolean isCellEditable(int row, int col) {
		return  false;
	}

	public final void setLang() {
		Whiteboard wb = MainWindow.getWhiteboard();
		columnNames[0] = wb.getLang().getString("dataType");
		columnNames[1] = wb.getLang().getString("syncStatus");
		columnNames[2] = wb.getLang().getString("localInserts");
		columnNames[3] = wb.getLang().getString("localUpdates"); 
	}
}
