package sellwin.gui;

import sellwin.domain.*;
import sellwin.server.*;
import sellwin.utils.*;

import java.util.*;
import java.rmi.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class implements the user maintenance
 * dialog which is viewable via the Admin menu
 * option on the MainWindow.
 */
public class UserAdminDialog extends JDialog implements GUIChars {

	private ArrayList allRolePairs = new ArrayList();
	private Whiteboard wb;
	private JDialog thisDialog;

    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton closeButton;
    private JPanel mainPanel;
    private JPanel userPanel;
    private JScrollPane userListScrollPane;
    private JList userList;
    private JTabbedPane tabbedPane;
    private AddressPanel addressPanel;
    private JScrollPane roleTableScrollPane;
    private JTable roleTable;

    private JPopupMenu userPopup = new JPopupMenu();
    private JMenuItem addMenuItem = new JMenuItem("Add User");
    private JMenuItem changePasswordMenuItem = new JMenuItem("Set Password");
    private JMenuItem deleteUserMenuItem = new JMenuItem("Delete User");

	private PasswordDialog passwordDialog;
	private UserIDDialog userIDDialog;

	private RoleTableModel roleTableModel;

    public UserAdminDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
		thisDialog = this;
		wb = MainWindow.getWhiteboard();
        initComponents();
		setFonts();
		setColors();
		setLang();
		getAllRoles();
		setData();
		setSize(530, 530);
	
		roleTableModel = new RoleTableModel(allRolePairs);	
		roleTable.setModel(roleTableModel);
    }


    /**
     *  set the dialog's data being displayed
     */
    public final void setData() {
        try {
            TreeMap map = wb.getSalesPersons();
			Object[] values = map.values().toArray();

            DefaultListModel model = new DefaultListModel();
            String id = null;
            SalesPerson sp = null;
            for (int i=0;i<values.length;i++) {
                sp = (SalesPerson)(values[i]);
                id = sp.getID();
                model.addElement(id);
            }

            userList.setModel(model);
        } catch (AngError e) {
            ErrorHandler.show(thisDialog, e);
        }
	}


	public final void setColors() {
        applyButton.setForeground(MainWindow.LETTERS);
        closeButton.setForeground(MainWindow.LETTERS);
	}

	public final void setFonts() {
		tabbedPane.setFont(MainWindow.LABEL_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
        closeButton.setFont(MainWindow.LABEL_FONT);
    	addMenuItem.setFont(MainWindow.LABEL_FONT);
    	changePasswordMenuItem.setFont(MainWindow.LABEL_FONT);
    	deleteUserMenuItem.setFont(MainWindow.LABEL_FONT);
	}

	public final void setLang() {
        tabbedPane.setTitleAt(0, wb.getLang().getString("address"));
        tabbedPane.setTitleAt(1, wb.getLang().getString("roles"));
    	addMenuItem.setText(wb.getLang().getString("addUser"));
    	changePasswordMenuItem.setText(wb.getLang().getString("setPassword"));
    	deleteUserMenuItem.setText(wb.getLang().getString("deleteUser"));
        applyButton.setText(wb.getLang().getString("apply"));
        closeButton.setText(wb.getLang().getString("close"));
        userPanel.setBorder(
			new TitledBorder(
                null, 
                wb.getLang().getString("users"),
                TitledBorder.DEFAULT_JUSTIFICATION,
                TitledBorder.DEFAULT_POSITION,
                MainWindow.LABEL_FONT,
                MainWindow.LETTERS
			)
		);
	}

    private void initComponents() {
        buttonPanel = new JPanel();
        applyButton = new JButton();
        closeButton = new JButton();
        mainPanel = new JPanel();
		mainPanel.setPreferredSize(new Dimension(400, 400));
		mainPanel.setMaximumSize(new Dimension(400, 400));
		mainPanel.setMinimumSize(new Dimension(400, 400));
        userPanel = new JPanel();
        userListScrollPane = new JScrollPane();
        userList = new JList();
        tabbedPane = new JTabbedPane();
        addressPanel = new AddressPanel();
        roleTableScrollPane = new JScrollPane();
        roleTable = new JTable();
        
    	userPopup.add(addMenuItem);
    	userPopup.add(changePasswordMenuItem);
    	userPopup.add(deleteUserMenuItem);
	
		passwordDialog = new PasswordDialog(this, true);
		userIDDialog = new UserIDDialog(this, true);

        setTitle("User Administration");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        applyButton.setText("Apply");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(applyButton);
        
        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        addMenuItem.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					userIDDialog.show();
				}
			}
		);

        changePasswordMenuItem.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
					passwordDialog.show();
				}
			}
		);

        deleteUserMenuItem.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String id = (String)userList.getSelectedValue();
                    try {
                        TreeMap all = wb.getSalesPersons();
                        SalesPerson sp = (SalesPerson)(all.get(id));
                        wb.deleteSalesPerson(sp);
						setData();

                        //String v = (String)userList.getSelectedValue();
                        //DefaultListModel m = (DefaultListModel)userList.getModel();
                        //m.removeElement(v);
                        //if (m.size() > 0) {
                            //userList.setSelectedIndex(m.size() - 1);
                            //id = (String)userList.getSelectedValue();
                            //if (id != null)
                                //loadSalesPerson(id);
                        //}
                    } catch (AngError x) {
                        ErrorHandler.show(thisDialog, x);
                    }
               	}
			} 
       	);
 
        buttonPanel.add(closeButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gbc2;
        
        mainPanel.setBorder(new EtchedBorder());
        userPanel.setBorder(new TitledBorder("Current Users"));
        userListScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        userListScrollPane.setPreferredSize(new java.awt.Dimension(200, 100));
        userList.setModel(new AbstractListModel() {
            String[] strings = { "one", "two" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });

        userList.addMouseListener(
			new java.awt.event.MouseAdapter() {
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger())
                        userPopup.show(userList, e.getX(), e.getY());
                }
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger())
                        userPopup.show(userList, e.getX(), e.getY());
                }
                public void mouseClicked(MouseEvent e) {
					switch (e.getClickCount()) {
						case 1:
							String id = (String)userList.getSelectedValue();
							if (id != null)
								loadSalesPerson(id);
							break;
						default:
							break;
					}
                    if (e.isPopupTrigger())
                        userPopup.show(userList, e.getX(), e.getY());
                }
            }
        );
        
        userListScrollPane.setViewportView(userList);
        
        userPanel.add(userListScrollPane);
        
        gbc2 = new java.awt.GridBagConstraints();
        gbc2.gridwidth = 1;
        //gbc2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc2.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(userPanel, gbc2);
        
        tabbedPane.setMinimumSize(new java.awt.Dimension(200, 200));
        tabbedPane.setMaximumSize(new java.awt.Dimension(200, 200));
        tabbedPane.addTab("Address", addressPanel);
        
        roleTableScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        roleTableScrollPane.setPreferredSize(new java.awt.Dimension(200, 200));
        roleTableScrollPane.setMinimumSize(new java.awt.Dimension(200, 200));
        roleTableScrollPane.setMaximumSize(new java.awt.Dimension(200, 200));
        roleTableScrollPane.setViewportView(roleTable);
        
        tabbedPane.addTab("Roles", roleTableScrollPane);
        
        gbc2 = new java.awt.GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gbc2.gridheight = 2;
        gbc2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gbc2.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(tabbedPane, gbc2);
        
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        
        pack();
    }

    private void userListMouseClickAction(java.awt.event.MouseEvent evt) {
        // Add your handling code here:
    }

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		setVisible(false);
		dispose();
    }

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {

		int option = JOptionPane.showConfirmDialog(
			thisDialog, wb.getLang().getString("continueUpdateQuestion"));

        if (option == JOptionPane.YES_OPTION) {
        	try {
            	SalesPerson s = getSalesPerson();

                if (s == null) return;

				updateWithNewRoles(s);
	
                wb.updateSalesPerson(s);
                JOptionPane.showMessageDialog(
                	thisDialog,
                	wb.getLang().getString("updateNotify"), 
					wb.getLang().getString("updateNotify"),
					JOptionPane.INFORMATION_MESSAGE);
            } catch (Exception f) {
            	ErrorHandler.show(thisDialog, f);
            }
		}
    }

	private void updateWithNewRoles(SalesPerson s) {
		s.getUserRoles().clear();
		RolePair rp;
		boolean now, orig;
		UserRole userRole;
		for (int i=0;i<allRolePairs.size(); i++) {
			rp = (RolePair)allRolePairs.get(i);
			now = rp.selected.booleanValue();
			orig = rp.origSelected.booleanValue();
			if (now != orig) {
				userRole = new UserRole();
				userRole.setPK(rp.pk);
				userRole.setName(rp.name);
				try {
					s.addUserRole(userRole);
				} catch (AngError e) { 
					ErrorHandler.show(thisDialog, e);
				}
			}
			rp.print();
		}
	}


    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }

    /**
     * get the SalesPerson data being shown by the dialog
     * @return the SalesPerson from the screen data
     */
    public final SalesPerson getSalesPerson() {
        SalesPerson s = null;  
        TreeMap all = null;
        try {
            all = wb.getSalesPersons(); 
        } catch (AngError e) {
            ErrorHandler.show(thisDialog, e);
            return s;
        }

        String idVal = (String)userList.getSelectedValue();
        s =  (SalesPerson)(all.get(idVal));
        Address a = addressPanel.getAddress();
        Address.copyFields(s.getAddress(), a);
        return s;
    }


    /**
     * load a sales person's info into this dialog
     * @param i an index into the list of sales persons to display
     */
    public final void loadSalesPerson(String id) {
        try {
			TreeMap map = wb.getSalesPersons();
			Object[] keys = map.keySet().toArray();
			String key;
			for (int i=0;i<keys.length;i++) {
				key = (String)keys[i];
				if (key.equals(id)) {
					userList.setSelectedIndex(i);
					break;
				}
			}
            SalesPerson sp = (SalesPerson)(map.get(id));
			ArrayList userRoles = sp.getUserRoles();
			clearRoles();
			UserRole userRole;
			for (int j=0;j<userRoles.size();j++) {
				userRole = (UserRole)userRoles.get(j);
				updatePairs(userRole.getName());
			}
			roleTable.tableChanged(new TableModelEvent(roleTableModel));
            setRoleData(sp.getUserRoles().toArray());
            addressPanel.setAddress(sp.getAddress());
        } catch (Exception e) {
            ErrorHandler.show(thisDialog, e);
        }
    }

	private final void updatePairs(String roleName) {
		RolePair pair;
		for (int i=0;i<allRolePairs.size();i++) {
			pair = (RolePair)allRolePairs.get(i);
			if (roleName.equals(pair.name))
				pair.selected = new Boolean(true);
		}
	}

	private final void getAllRoles() {
		try {
			ArrayList allRoles = wb.getAllUserRoles();
		
			RolePair pair;
			UserRole role;
	
			for (int i=0;i<allRoles.size();i++) {
				role = (UserRole)allRoles.get(i);
				pair = new RolePair();
				pair.pk = role.getPK();
				pair.name = role.getName();
				pair.selected = new Boolean(false);
				pair.origSelected = new Boolean(false);
				allRolePairs.add(pair);
			}
			
    		setRoleData(allRolePairs.toArray());
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	private final void clearRoles() {
		RolePair pair;
		for (int i=0;i<allRolePairs.size();i++) {
			pair = (RolePair)allRolePairs.get(i);
			pair.selected = new Boolean(false);
			pair.origSelected = new Boolean(false);
		}
	}

    /**
     * set the user role data to display
     * @param roles an array of UserRole objects to displsy
     */
    public final void setRoleData(Object[] roles) {
//        DefaultListModel model = new DefaultListModel();
//        UserRole role = null;
        for (int i=0;i<roles.length;i++) {
//            role = (UserRole)roles[i];
//            model.addElement(role.getName());
        }

 //       roleList.setModel(model);
    }

	public void setPassword(String psw) {
		SalesPerson s = getSalesPerson();
		s.setPassword(psw);	
		try {
			wb.updateSalesPerson(s);
            JOptionPane.showMessageDialog(
            	thisDialog,
                wb.getLang().getString("updateNotify"), 
				wb.getLang().getString("updateNotify"),
				JOptionPane.INFORMATION_MESSAGE);
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}

	public void addUser(String id, String psw) {
		try {
			SalesPerson s = new SalesPerson();
			s.setID(id);
			s.setPassword(psw);
			wb.addSalesPerson(s);
			setData();
			//DefaultListModel m = (DefaultListModel)userList.getModel();
			//m.addElement(s.getID());
			//userList.setSelectedIndex(m.size() -1 );
			//String idVal = (String)userList.getSelectedValue();
			//if (idVal != null)
			//	loadSalesPerson(idVal);
			loadSalesPerson(id);
	
			//make sure the new user shows up in the sales group dialog
			MainWindow.getSalesGroupDialog().loadData();
		} catch (AngError e) {
			ErrorHandler.show(thisDialog, e);
		}
	}
}

class UserIDDialog extends JDialog implements GUIChars {

	private Whiteboard wb;
	private UserAdminDialog parent;
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton closeButton;
    private JPanel mainPanel;
    private JLabel idLabel;
    private JTextField idField;
    private JLabel pswLabel;
    private JPasswordField pswField;
    private JLabel psw2Label;
    private JPasswordField psw2Field;

    /** Creates new form UserIDDialog */
    public UserIDDialog(UserAdminDialog parent, boolean modal) {
        super(parent, modal);
		this.parent = parent;
		wb = MainWindow.getWhiteboard();
        initComponents();
		setLang();
		setColors();
		setFonts();
		int width=300;
		int height=190;
		setSize(width, height);
        getRootPane().setDefaultButton(applyButton);
    }

	public final void setLang() {
		setTitle(wb.getLang().getString("enterUserID"));
        applyButton.setText(wb.getLang().getString("apply"));
		closeButton.setText(wb.getLang().getString("close"));
        pswLabel.setText(wb.getLang().getString("password"));
        psw2Label.setText(wb.getLang().getString("retype"));
	}
	
	public final void setColors() {
        idLabel.setForeground(MainWindow.LETTERS);
        pswLabel.setForeground(MainWindow.LETTERS);
        psw2Label.setForeground(MainWindow.LETTERS);
	}

	public final void setFonts() {
        idLabel.setFont(MainWindow.LABEL_FONT);
        pswLabel.setFont(MainWindow.LABEL_FONT);
        psw2Label.setFont(MainWindow.LABEL_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
        closeButton.setFont(MainWindow.LABEL_FONT);
        idField.setFont(MainWindow.FIELD_FONT);
        pswField.setFont(MainWindow.FIELD_FONT);
        psw2Field.setFont(MainWindow.FIELD_FONT);
	}

    private void initComponents() {
        buttonPanel = new JPanel();
        applyButton = new JButton();
        closeButton = new JButton();
        mainPanel = new JPanel();
        idLabel = new JLabel();
        idField = new JTextField();
        pswLabel = new JLabel();
        psw2Label = new JLabel();
        pswField = new JPasswordField();
        psw2Field = new JPasswordField();
        
        setTitle("Enter User ID");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        applyButton.setText("Apply");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(applyButton);
        
        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
				pswField.setText("");
				psw2Field.setText("");
				idField.setText("");
                closeButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(closeButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        idLabel.setText("User ID");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        mainPanel.add(idLabel, gridBagConstraints2);
        
        idField.setText("");
        idField.setPreferredSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        idField.setMaximumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        idField.setMinimumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(2, 7, 2, 7);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        mainPanel.add(idField, gridBagConstraints2);
        
        pswLabel.setText("Password");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        mainPanel.add(pswLabel, gridBagConstraints2);
        
        pswField.setText("");
        pswField.setPreferredSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        pswField.setMaximumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        pswField.setMinimumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.insets = new java.awt.Insets(2, 7, 2, 7);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        mainPanel.add(pswField, gridBagConstraints2);
        
        psw2Label.setText("Re-Enter");
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        mainPanel.add(psw2Label, gridBagConstraints2);
        
        psw2Field.setText("");
        psw2Field.setPreferredSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        psw2Field.setMaximumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        psw2Field.setMinimumSize(new Dimension(60, Prefs.FIELD_HEIGHT));
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new java.awt.Insets(2, 7, 2, 7);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(psw2Field, gridBagConstraints2);
        
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        
        pack();
    }

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		setVisible(false);
		dispose();
    }

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {
	
		char[] psw1 = pswField.getPassword();	
		char[] psw2 = psw2Field.getPassword();	

		String psw1Str = new String(psw1);
		String psw2Str = new String(psw2);
	
		if (!psw1Str.equals(psw2Str)) {
			ErrorHandler.show(this, 
				new AngError(wb.getLang().getString("passwordMatch")));
			return;
		}
		
		parent.addUser(idField.getText(), psw1Str);
    	idField.setText("");
    	pswField.setText("");
    	psw2Field.setText("");
		closeButtonActionPerformed(evt);
    }

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }
}

class PasswordDialog extends JDialog implements GUIChars {

	private UserAdminDialog parent;
	private Whiteboard wb;

    private JPanel mainPanel;
    private JLabel passwordLabel;
    private JLabel retypeLabel;
    private JPasswordField passwordField;
    private JPasswordField retypeField;
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton cancelButton;

    /** Creates new form PasswordDialog */
    public PasswordDialog(UserAdminDialog parent, boolean modal) {
        super(parent, modal);
		this.parent = parent;
		wb = MainWindow.getWhiteboard();
        initComponents();
		setColors();
		setFonts();
		setLang();
        getRootPane().setDefaultButton(applyButton);
		setSize(300, 140);
    }

	public final void setLang() {
        setTitle(wb.getLang().getString("setPassword"));
        passwordLabel.setText(wb.getLang().getString("password"));
        retypeLabel.setText(wb.getLang().getString("retype"));
        applyButton.setText(wb.getLang().getString("apply"));
        cancelButton.setText(wb.getLang().getString("cancel"));
	}
	
	public final void setColors() {
        passwordLabel.setForeground(MainWindow.LETTERS);
        retypeLabel.setForeground(MainWindow.LETTERS);
	}

	public final void setFonts() {
        passwordLabel.setFont(MainWindow.LABEL_FONT);
        retypeLabel.setFont(MainWindow.LABEL_FONT);
        passwordField.setFont(MainWindow.FIELD_FONT);
        retypeField.setFont(MainWindow.FIELD_FONT);
        applyButton.setFont(MainWindow.LABEL_FONT);
        cancelButton.setFont(MainWindow.LABEL_FONT);
	}

    private void initComponents() {
        mainPanel = new JPanel();
        passwordLabel = new JLabel();
        retypeLabel = new JLabel();
        passwordField = new JPasswordField();
        retypeField = new JPasswordField();
        buttonPanel = new JPanel();
        applyButton = new JButton();
        cancelButton = new JButton();
        
        setTitle("Set Password");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        mainPanel.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        mainPanel.setBorder(new javax.swing.border.EtchedBorder());
        passwordLabel.setText("Password");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(passwordLabel, gridBagConstraints1);
        
        retypeLabel.setText("Password Retype");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(retypeLabel, gridBagConstraints1);
        
        passwordField.setPreferredSize(new java.awt.Dimension(100, 20));
        passwordField.setMaximumSize(new java.awt.Dimension(100, 20));
        passwordField.setMinimumSize(new java.awt.Dimension(100, 20));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(2, 7, 2, 7);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(passwordField, gridBagConstraints1);
        
        retypeField.setPreferredSize(new java.awt.Dimension(100, 20));
        retypeField.setMaximumSize(new java.awt.Dimension(100, 20));
        retypeField.setMinimumSize(new java.awt.Dimension(100, 20));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(2, 7, 2, 7);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        mainPanel.add(retypeField, gridBagConstraints1);
        
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        
        applyButton.setText("Apply");
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(applyButton);
        
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        buttonPanel.add(cancelButton);
        
        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        
        pack();
    }

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
		setVisible(false);
		dispose();
    }

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {
		char[] psw1 = passwordField.getPassword();	
		char[] psw2 = retypeField.getPassword();	

		String psw1Str = new String(psw1);
		String psw2Str = new String(psw2);
	
		if (!psw1Str.equals(psw2Str)) {
			ErrorHandler.show(this, 
				new AngError(wb.getLang().getString("passwordMatch")));
			return;
		}
		parent.setPassword(new String(passwordField.getPassword()));
		passwordField.setText("");
		retypeField.setText("");
		setVisible(false);
		dispose();
    }

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
		retypeField.setText("");
		passwordField.setText("");
        setVisible(false);
        dispose();
    }
}

class RoleTableModel extends AbstractTableModel {
	private String[] columnNames = { "Role", "Selected" };

	private ArrayList wholeList = null;
	
	private RolePair pair = new RolePair();

	public RoleTableModel(ArrayList wholeList) {
		
		this.wholeList = wholeList;
		pair.name = "TEST";
		pair.selected = new Boolean(true);
	}

	public final ArrayList getList() {
		return wholeList;
	}

	public Object getValueAt(int row, int col) {
		RolePair pair = null;
		pair = (RolePair)wholeList.get(row);
		switch (col) {
			case 0: //role name
				return pair.name;
			case 1: //selected
				return pair.selected;
			default:
				System.out.println("role table value bad");
		}
		return null;
	}

	public Class getColumnClass(int col) {
		switch (col) {
			case 0: //role name
				return pair.name.getClass();
			case 1:
				return pair.selected.getClass();
			default:
				System.out.println("something is wrong");
		}
		return null;
	}

	public void setValueAt(Object value, int row, int col) {
		RolePair pair = null;
		pair = (RolePair)wholeList.get(row);
		switch (col) {
			case 0: //role name
				break;
			case 1: //selected
				pair.selected = (Boolean)value;
				break;
		}
		fireTableCellUpdated(row, col);
	}

	public final boolean isCellEditable(int row, int col) {
		Class cls = getColumnClass(col);
		String name = getColumnName(col);
		if (name.equals("Selected")) {
			return true;
		}
	
		return false;
	}

	public int getRowCount() {
		return wholeList.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	public String getColumnName(int col) {
		return columnNames[col];
	}
}

class RolePair {
	public long pk; //the UserRole pk
	public String name;
	public Boolean selected;
	public Boolean origSelected;

	public void print() {
		System.out.println(name + " now=" + selected + " orig=" + origSelected);
	}
}
