package sellwin.gui;

import java.util.*;
import java.awt.*;
import javax.swing.*;
import javax.naming.*;
import javax.ejb.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class has some simple GUI routines that save
 * some extra lines of code.
 */
public class Utility {
	/**
	 * set the text of a text area  
	 * @param f the text area we are setting
	 * @param from the text we are setting with
	 */
	public static void strSet(JTextArea f, String from) {
		if (from != null) {
			f.setText(from);
			f.setCaretPosition(0);
		}
		else
			f.setText("");
	}
	/**
	 * set the text portion of a text field 
	 * @param f a text field we are setting
	 * @param from a string we are setting to
	 */
	public static void strSet(JTextField f, String from) {
		if (from != null) {
			f.setText(from);
			f.setCaretPosition(0);
		}
		else
			f.setText("");
	}
	/**
	 * set the index of a combo box to a given item
	 * @param b the combo box we are setting
	 * @param item the item in the combo box we are setting
	 * with
	 */
	public static void comboSet(JComboBox b, Object item) {
		if (item != null)
			b.setSelectedItem(item);
		else
			b.setSelectedIndex(0);
	}

	/**
	 * loop thru all the components of a container and
	 * call setLang() for those that implement the
	 * GUIChars interface
	 */
	public static void setLang(Container container) {
		Component[] components = container.getComponents();
		Component c;

		for (int i=0;i<components.length;i++) {
			c = components[i];
			if (c instanceof Container) {
				Utility.setLang((Container)c);
			}
		
			if (c instanceof GUIChars) {
				((GUIChars)c).setLang();	
			}

			if (c instanceof JDialog) {
				if (c instanceof GUIChars)
					((GUIChars)c).setLang();	
				else
					Utility.setLang((Container)c);
		
			}

		}
	}

	public static InitialContext getEJBContext(String host, String port)  
		throws NamingException {

		Hashtable props = new Hashtable();
        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.put("java.naming.provider.url","jnp://"+host+":"+port);
        props.put("java.naming.factory.url.pkgs","org.jboss.naming:org.jnp.interfaces");

		InitialContext ic = new InitialContext(props);
		return ic;
	}
}
