package sellwin.server;

import java.io.*;
import java.net.*;
import java.util.*;
import sellwin.domain.*;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * this class is a thread that runs all the time
 * in the chat server to see if any online users
 * have logged off or died and therefore need to
 * be removed from the global online list of users
 */
public class ChatReaper extends Thread {

	/** the list of online users */
	private TreeMap onlineUsers = null;

	/** 
	 * construct the thread, referring to
	 * the online users list
	 * @param onlineUsers the online users list reference
	 */
    public ChatReaper(TreeMap onlineUsers) {
		this.onlineUsers = onlineUsers;
    }

	/**
	 * this is the run() of this thread which executes all the
	 * time, waking up at intervals, does the online users check
	 * and goes back to sleep
	 */
    public void run() {
		try {
	    	while(true) {
				sleep(9000);
				userCheck();
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
    }

	/**
	 * check the online list for dead users
	 */
	private void userCheck() {
		ChatConnInfo info = null;
		Object[] keys = onlineUsers.keySet().toArray();

		if (keys == null) return;

		for (int i=0;i<onlineUsers.size();i++) {
			info = (ChatConnInfo)onlineUsers.get(keys[i]);
			System.out.println(info.getSender() + " connected since " + info.getConnectedSince());
			if (info.stillConnected())
				System.out.println(info.getSender() + " not reaped yet");
			else {
				System.out.println("reaping " + info.getSender());
				onlineUsers.remove(info.getSender());
			}
		}
	}
}
