package sellwin.server;


import java.util.*;
import java.rmi.*;

import javax.ejb.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

// SellWin http://sourceforge.net/projects/sellwincrm
//Contact support@open-app.com for commercial help with SellWin
//This software is provided "AS IS", without a warranty of any kind.

/**
 * This class offers some routines that help establish
 * an EJB client-server connection.  These routines
 * are used by the GUI when logging into the sellwin
 * server and also for the sync process.
 */
public class EJBUtils {
   	public final static String JNDI_NAME="SellwinSessionHome";
   	public final static String WEBLOGIC_URL="t3://localhost:7001";
    /**
    * Using a Properties object will work on JDK 1.1.x and Java2
    * clients
    */
    public static Context getInitialContext() throws NamingException {

        try {
            // Get an InitialContext
            Properties h = new Properties();
            h.put(Context.INITIAL_CONTEXT_FACTORY,
                "weblogic.jndi.WLInitialContextFactory");
            h.put(Context.PROVIDER_URL, WEBLOGIC_URL);
            return new InitialContext(h);
        } catch (NamingException ne) {
            System.out.println("We were unable to get a connection to the WebLogic server at "+WEBLOGIC_URL);
            System.out.println("Please make sure that the server is running.");
            throw ne;
        }
    }

    /**
     *  RMI/IIOP clients should use this narrow function
     */
    public static Object narrow(Object ref, Class c) {
        return PortableRemoteObject.narrow(ref, c);
    }

    public static SellwinSession ejbConnect()
        throws NamingException, CreateException, RemoteException {

        String JNDI_NAME = "SellwinSessionHome";

        Context ctx = getInitialContext();

        Object home = ctx.lookup(JNDI_NAME);
        SellwinSessionHome sellwinHome = (SellwinSessionHome)narrow(home, SellwinSessionHome.class);
		System.out.println("found sellwin session home in jndi");

        SellwinSession sellwin = (SellwinSession)narrow(sellwinHome.create(), SellwinSession.class);
		System.out.println("created SellwinSession remote reference");
        return sellwin;

    }

}
